/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryPathFinder {
    private static final String JAVA = ".java";
    private static final String EMPTY = "";
    private static final String DOT_REGEX = "\\.";
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\\\";
    private DirectoryScanner scanner = new DirectoryScanner();

    public List<String> listStoryPaths(String basedir, String rootPath, List<String> includes, List<String> excludes) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : this.listPaths(basedir, rootPath, includes, excludes)) {
            paths.add(this.normalise(path));
        }
        return paths;
    }

    private String normalise(String path) {
        if (path.indexOf(JAVA) != -1) {
            String className = path.substring(0, path.indexOf(JAVA));
            className = className.replaceAll(SLASH, DOT_REGEX);
            return className.replaceAll(BACKSLASH, DOT_REGEX);
        }
        if (path.startsWith(SLASH)) {
            return path.substring(1);
        }
        return path;
    }

    private List<String> listPaths(String basedir, String rootPath, List<String> includes, List<String> excludes) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!new File(basedir).exists()) {
            return paths;
        }
        this.scanner.setBasedir(basedir);
        if (includes != null) {
            this.scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            this.scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        this.scanner.scan();
        String basePath = rootPath != null ? rootPath + SLASH : EMPTY;
        for (String relativePath : this.scanner.getIncludedFiles()) {
            String path = basePath + relativePath;
            paths.add(path);
        }
        return paths;
    }
}

