/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StoryLocation {
    private final URL codeLocation;
    private final String storyPath;
    private final boolean url;

    public StoryLocation(URL codeLocation, String storyPath) {
        this.codeLocation = codeLocation;
        this.storyPath = storyPath;
        this.url = this.isURL(storyPath);
    }

    public URL getCodeLocation() {
        return this.codeLocation;
    }

    public String getPath() {
        return this.storyPath;
    }

    public String getLocation() {
        if (this.url) {
            return this.storyPath;
        }
        return this.codeLocation + this.storyPath;
    }

    public String getName() {
        if (this.url) {
            return StringUtils.removeStart((String)this.storyPath, (String)this.codeLocation.toString());
        }
        return this.storyPath;
    }

    public boolean isURL() {
        return this.url;
    }

    private boolean isURL(String storyPath) {
        try {
            new URL(storyPath);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

