/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.StoryLoader;

public class LoadFromRelativeFile
implements StoryLoader {
    private final StoryFilePath[] traversals;
    private final URL location;

    public LoadFromRelativeFile(URL location) {
        this(location, LoadFromRelativeFile.mavenModuleStoryFilePath("src/test/java"));
    }

    public LoadFromRelativeFile(URL location, StoryFilePath ... traversals) {
        this.traversals = traversals;
        this.location = location;
    }

    public String loadStoryAsText(String storyPath) {
        String badFileLocations = "";
        for (StoryFilePath traversal : this.traversals) {
            try {
                String fileLocation = new File(this.location.getFile()).getCanonicalPath() + "/";
                fileLocation = fileLocation.replace(traversal.toRemove, "") + "/" + traversal.relativePath + "/" + storyPath;
                fileLocation = fileLocation.replace("/", File.separator);
                File file = new File(fileLocation);
                if (file.exists()) {
                    return IOUtils.toString((InputStream)new FileInputStream(file));
                }
                if (badFileLocations.length() > 0) {
                    badFileLocations = badFileLocations + ", ";
                }
                badFileLocations = badFileLocations + fileLocation;
            }
            catch (IOException e) {
                throw new InvalidStoryResource("Story path '" + storyPath + "' not found.", e);
            }
        }
        throw new InvalidStoryResource("Story path '" + storyPath + "' not found while looking in '" + badFileLocations + "'", null);
    }

    public static StoryFilePath mavenModuleStoryFilePath(String relativePath) {
        return new StoryFilePath("target/classes", relativePath);
    }

    public static StoryFilePath mavenModuleTestStoryFilePath(String relativePath) {
        return new StoryFilePath("target/test-classes", relativePath);
    }

    public static StoryFilePath intellijProjectStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/production", relativePath);
    }

    public static StoryFilePath intellijProjectTestStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/test", relativePath);
    }

    public static class StoryFilePath {
        private final String toRemove;
        private final String relativePath;

        public StoryFilePath(String toRemove, String relativePath) {
            this.toRemove = toRemove;
            this.relativePath = relativePath;
        }
    }
}

