/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryResourceNotFound;

public class LoadFromClasspath
implements StoryLoader {
    private final ClassLoader classLoader;

    public LoadFromClasspath() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public LoadFromClasspath(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String loadStoryAsText(String storyPath) {
        InputStream stream = this.classLoader.getResourceAsStream(storyPath);
        if (stream == null) {
            throw new StoryResourceNotFound(storyPath, this.classLoader);
        }
        try {
            return IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new InvalidStoryResource(storyPath, stream, e);
        }
    }
}

