/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeLocations {
    public static URL codeLocationFromClass(Class<?> codeLocationClass) {
        String pathOfClass = codeLocationClass.getName().replace(".", "/") + ".class";
        URL classResource = codeLocationClass.getClassLoader().getResource(pathOfClass);
        String codeLocationPath = StringUtils.removeEnd((String)classResource.getFile(), (String)pathOfClass);
        return CodeLocations.codeLocationFromPath(codeLocationPath);
    }

    public static URL codeLocationFromPath(String codeLocationPath) {
        try {
            return new File(codeLocationPath).toURL();
        }
        catch (MalformedURLException e) {
            throw new InvalidCodeLocation(codeLocationPath);
        }
    }

    public static class InvalidCodeLocation
    extends RuntimeException {
        public InvalidCodeLocation(String path) {
            super(path);
        }
    }
}

