/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import org.jbehave.core.RunnableStory;
import org.jbehave.core.io.StoryPathResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoryPathResolver
implements StoryPathResolver {
    static final String DOT_REGEX = "\\.";
    static final String SLASH = "/";
    static final String EMPTY = "";
    static final String DEFAULT_EXTENSION = ".story";
    private final String extension;

    protected AbstractStoryPathResolver() {
        this(DEFAULT_EXTENSION);
    }

    protected AbstractStoryPathResolver(String extension) {
        this.extension = extension;
    }

    @Override
    public String resolve(Class<? extends RunnableStory> storyClass) {
        return this.formatPath(this.resolveDirectory(storyClass), this.resolveName(storyClass), this.extension);
    }

    private String formatPath(String directory, String name, String extension) {
        StringBuffer sb = new StringBuffer();
        if (directory.length() > 0) {
            sb.append(directory).append(SLASH);
        }
        sb.append(name);
        if (extension.length() > 0) {
            sb.append(extension);
        }
        return sb.toString();
    }

    protected String resolveDirectory(Class<? extends RunnableStory> scenarioClass) {
        Package scenarioPackage = scenarioClass.getPackage();
        if (scenarioPackage != null) {
            return scenarioPackage.getName().replaceAll(DOT_REGEX, SLASH);
        }
        return EMPTY;
    }

    protected abstract String resolveName(Class<? extends RunnableStory> var1);
}

