/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.i18n;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.lang.CharEncoding;

public class StringCoder {
    private final String charsetName;

    public StringCoder() {
        this(Charset.defaultCharset().name());
    }

    public StringCoder(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public boolean isCharsetSupported() {
        return CharEncoding.isSupported((String)this.charsetName);
    }

    public String canonicalize(String input) {
        try {
            return new String(input.getBytes(this.charsetName), this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidEncodingException(input, e);
        }
    }

    public void validateEncoding(String input, Mode mode) {
    }

    public static final class InvalidEncodingException
    extends RuntimeException {
        public InvalidEncodingException(String message) {
            super(message);
        }

        public InvalidEncodingException(String input, UnsupportedEncodingException cause) {
            super(input, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        STRICT,
        WARN;

    }
}

