/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jbehave.core.StoryClassLoader;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.StringCoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedKeywords
extends Keywords {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final StringCoder DEFAULT_STRING_ENCODER = new StringCoder();
    private static final String DEFAULT_BUNDLE_NAME = "org/jbehave/core/i18n/keywords";
    private static final ClassLoader DEFAULT_CLASS_LOADER = Thread.currentThread().getContextClassLoader();

    public LocalizedKeywords() {
        this(DEFAULT_LOCALE, DEFAULT_STRING_ENCODER, DEFAULT_BUNDLE_NAME, DEFAULT_CLASS_LOADER);
    }

    public LocalizedKeywords(Locale locale) {
        this(locale, DEFAULT_STRING_ENCODER, DEFAULT_BUNDLE_NAME, DEFAULT_CLASS_LOADER);
    }

    public LocalizedKeywords(Locale locale, StringCoder encoder) {
        this(locale, encoder, DEFAULT_BUNDLE_NAME, DEFAULT_CLASS_LOADER);
    }

    public LocalizedKeywords(Locale locale, StringCoder encoder, String bundleName) {
        super(LocalizedKeywords.keywords(bundleName, locale, encoder, DEFAULT_CLASS_LOADER), encoder);
    }

    public LocalizedKeywords(Locale locale, StringCoder encoder, String bundleName, ClassLoader classLoader) {
        super(LocalizedKeywords.keywords(bundleName, locale, encoder, classLoader), encoder);
    }

    private static Map<String, String> keywords(String bundleName, Locale locale, StringCoder encoder, ClassLoader classLoader) {
        ResourceBundle bundle = LocalizedKeywords.lookupBunde(bundleName.trim(), locale, classLoader);
        HashMap<String, String> keywords = new HashMap<String, String>();
        for (String key : KEYWORDS) {
            keywords.put(key, LocalizedKeywords.keyword(key, bundle, encoder));
        }
        return keywords;
    }

    private static String keyword(String name, ResourceBundle bundle, StringCoder encoder) {
        try {
            return encoder.canonicalize(bundle.getString(name));
        }
        catch (MissingResourceException e) {
            throw new LocalizedKeywordNotFoundException(name, bundle);
        }
    }

    private static ResourceBundle lookupBunde(String bundleName, Locale locale, ClassLoader classLoader) {
        try {
            if (classLoader instanceof StoryClassLoader) {
                return ResourceBundle.getBundle(bundleName, locale, classLoader);
            }
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException e) {
            throw new ResourceBundleNotFoundException(bundleName, locale, classLoader, e);
        }
    }

    public static final class LocalizedKeywordNotFoundException
    extends RuntimeException {
        public LocalizedKeywordNotFoundException(String name, ResourceBundle bundle) {
            super("I18nKeyword " + name + " not found in resource bundle " + bundle);
        }
    }

    public static final class ResourceBundleNotFoundException
    extends RuntimeException {
        public ResourceBundleNotFoundException(String bundleName, Locale locale, ClassLoader classLoader, MissingResourceException cause) {
            super("Resource bundle " + bundleName + " not found for locale " + locale + " in classLoader " + classLoader, cause);
        }
    }
}

