/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.RunnableStory;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.SilentlyAbsorbingFailure;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryRunner {
    private State state = new FineSoFar();
    private FailureStrategy currentStrategy;
    private PendingStepStrategy pendingStepStrategy;
    private StoryReporter reporter;
    private FailureStrategy failureStrategy;
    private Throwable storyFailure;
    private StepCollector stepCollector;
    private String reporterStoryPath;

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Class<? extends RunnableStory> storyClass) throws Throwable {
        String storyPath = configuration.storyPathResolver().resolve(storyClass);
        this.run(configuration, candidateSteps, storyPath);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, String storyPath) throws Throwable {
        Story story = this.defineStory(configuration, storyPath);
        this.run(configuration, candidateSteps, story);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story) throws Throwable {
        this.run(configuration, candidateSteps, story, false);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, String storyPath, boolean givenStory) throws Throwable {
        Story story = this.defineStory(configuration, storyPath);
        this.run(configuration, candidateSteps, story, givenStory);
    }

    public Story defineStory(Configuration configuration, String storyPath) {
        String storyAsString = configuration.storyLoader().loadStoryAsText(storyPath);
        Story story = configuration.storyParser().parseStory(storyAsString, storyPath);
        story.namedAs(new File(storyPath).getName());
        return story;
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story, boolean givenStory) throws Throwable {
        this.stepCollector = configuration.stepCollector();
        this.reporter = this.reporterFor(configuration, story, givenStory);
        this.pendingStepStrategy = configuration.pendingStepStrategy();
        this.failureStrategy = configuration.failureStrategy();
        this.resetFailureState(givenStory);
        if (this.isDryRun(candidateSteps)) {
            this.reporter.dryRun();
        }
        this.reporter.beforeStory(story, givenStory);
        this.runStorySteps(candidateSteps, story, givenStory, StepCollector.Stage.BEFORE);
        for (Scenario scenario : story.getScenarios()) {
            this.reporter.beforeScenario(scenario.getTitle());
            this.runGivenStories(configuration, candidateSteps, scenario);
            if (this.isExamplesTableScenario(scenario)) {
                this.runExamplesTableScenario(candidateSteps, scenario);
            } else {
                this.runScenarioSteps(candidateSteps, scenario, new HashMap<String, String>());
            }
            this.reporter.afterScenario();
        }
        this.runStorySteps(candidateSteps, story, givenStory, StepCollector.Stage.AFTER);
        this.reporter.afterStory(givenStory);
        this.currentStrategy.handleFailure(this.storyFailure);
    }

    private boolean isDryRun(List<CandidateSteps> candidateSteps) {
        for (CandidateSteps steps : candidateSteps) {
            if (!steps.configuration().dryRun()) continue;
            return true;
        }
        return false;
    }

    private StoryReporter reporterFor(Configuration configuration, Story story, boolean givenStory) {
        if (givenStory) {
            return configuration.storyReporter(this.reporterStoryPath);
        }
        this.reporterStoryPath = story.getPath();
        return configuration.storyReporter(this.reporterStoryPath);
    }

    private void resetFailureState(boolean givenStory) {
        if (givenStory) {
            return;
        }
        this.currentStrategy = new SilentlyAbsorbingFailure();
        this.storyFailure = null;
    }

    private void runGivenStories(Configuration configuration, List<CandidateSteps> candidateSteps, Scenario scenario) throws Throwable {
        List<String> storyPaths = scenario.getGivenStoryPaths();
        if (storyPaths.size() > 0) {
            this.reporter.givenStories(storyPaths);
            for (String storyPath : storyPaths) {
                this.run(configuration, candidateSteps, storyPath, true);
            }
        }
    }

    private boolean isExamplesTableScenario(Scenario scenario) {
        return scenario.getTable().getRowCount() > 0;
    }

    private void runExamplesTableScenario(List<CandidateSteps> candidateSteps, Scenario scenario) {
        ExamplesTable table = scenario.getTable();
        this.reporter.beforeExamples(scenario.getSteps(), table);
        for (Map<String, String> tableRow : table.getRows()) {
            this.reporter.example(tableRow);
            this.runScenarioSteps(candidateSteps, scenario, tableRow);
        }
        this.reporter.afterExamples();
    }

    private void runStorySteps(List<CandidateSteps> candidateSteps, Story story, boolean givenStory, StepCollector.Stage stage) {
        this.runSteps(this.stepCollector.collectStepsFrom(candidateSteps, story, stage, givenStory));
    }

    private void runScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> tableRow) {
        this.runSteps(this.stepCollector.collectStepsFrom(candidateSteps, scenario, tableRow));
    }

    private void runSteps(List<Step> steps) {
        if (steps == null || steps.size() == 0) {
            return;
        }
        this.state = new FineSoFar();
        for (Step step : steps) {
            this.state.run(step);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static interface State {
        public void run(Step var1);
    }

    private final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        public void run(Step step) {
            StepResult result = step.perform();
            result.describeTo(StoryRunner.this.reporter);
            Throwable scenarioFailure = result.getFailure();
            if (scenarioFailure != null) {
                StoryRunner.this.state = new SomethingHappened();
                StoryRunner.this.storyFailure = this.mostImportantOf(StoryRunner.this.storyFailure, scenarioFailure);
                StoryRunner.this.currentStrategy = this.strategyFor(StoryRunner.this.storyFailure);
            }
        }

        private Throwable mostImportantOf(Throwable failure1, Throwable failure2) {
            return failure1 == null ? failure2 : (failure1 instanceof PendingStepFound ? (failure2 == null ? failure1 : failure2) : failure1);
        }

        private FailureStrategy strategyFor(Throwable failure) {
            if (failure instanceof PendingStepFound) {
                return StoryRunner.this.pendingStepStrategy;
            }
            return StoryRunner.this.failureStrategy;
        }
    }

    private class SomethingHappened
    implements State {
        private SomethingHappened() {
        }

        public void run(Step step) {
            StepResult result = step.doNotPerform();
            result.describeTo(StoryRunner.this.reporter);
        }
    }
}

