/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.embedder.EmbedderMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamEmbedderMonitor
implements EmbedderMonitor {
    private PrintStream output;

    public PrintStreamEmbedderMonitor() {
        this(System.out);
    }

    public PrintStreamEmbedderMonitor(PrintStream output) {
        this.output = output;
    }

    @Override
    public void storiesBatchFailed(String failedStories) {
        this.print("Failed to run batch stories " + failedStories);
    }

    @Override
    public void storyFailed(String storyName, Throwable e) {
        this.print("Failed to run story " + storyName);
        this.printStackTrace(e);
    }

    @Override
    public void runningStory(String storyName) {
        this.print("Running story " + storyName);
    }

    @Override
    public void storiesNotRun() {
        this.print("Stories not run");
    }

    @Override
    public void generatingStoriesView(File outputDirectory, List<String> formats, Properties viewProperties) {
        this.print("Generating stories view in '" + outputDirectory + "' using formats '" + formats + "'" + " and view properties '" + viewProperties + "'");
    }

    @Override
    public void storiesViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
        this.print("Failed to generate stories view in outputDirectory " + outputDirectory + " using formats " + formats + " and view properties '" + viewProperties + "'");
    }

    @Override
    public void storiesViewGenerated(int scenarios, int failedScenarios) {
        this.print("Stories view generated with " + scenarios + " scenarios (of which  " + failedScenarios + " failed)");
    }

    @Override
    public void storiesViewNotGenerated() {
        this.print("Stories view not generated");
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected void print(String message) {
        this.output.println(message);
    }

    protected void printStackTrace(Throwable e) {
        e.printStackTrace(this.output);
    }
}

