/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.RunnableStory;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.PrintStreamEmbedderMonitor;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.reporters.CandidateStepReporter;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.CandidateStep;
import org.jbehave.core.steps.CandidateStepFinder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepdocGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedder {
    private Configuration configuration = new MostUsefulConfiguration();
    private List<CandidateSteps> candidateSteps = new ArrayList<CandidateSteps>();
    private StoryRunner storyRunner;
    private EmbedderMonitor embedderMonitor;

    public Embedder() {
        this(new StoryRunner(), new PrintStreamEmbedderMonitor());
    }

    public Embedder(StoryRunner storyRunner, EmbedderMonitor embedderMonitor) {
        this.storyRunner = storyRunner;
        this.embedderMonitor = embedderMonitor;
    }

    public void runStories(List<RunnableStory> runnableStories) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesNotRun();
            return;
        }
        HashMap<String, Throwable> failedStories = new HashMap<String, Throwable>();
        for (RunnableStory story : runnableStories) {
            String storyName = story.getClass().getName();
            try {
                this.embedderMonitor.runningStory(storyName);
                story.useEmbedder(this);
                story.run();
            }
            catch (Throwable e) {
                if (embedderControls.batch()) {
                    failedStories.put(storyName, e);
                    continue;
                }
                if (embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(storyName, e);
                    continue;
                }
                throw new RunningStoriesFailedException("Failed to run story " + storyName, e);
            }
        }
        if (embedderControls.batch() && failedStories.size() > 0) {
            if (embedderControls.ignoreFailureInStories()) {
                this.embedderMonitor.storiesBatchFailed(this.format(failedStories));
            } else {
                throw new RunningStoriesFailedException("Failed to run stories in batch: " + this.format(failedStories));
            }
        }
        if (embedderControls.generateViewAfterStories()) {
            this.generateStoriesView();
        }
    }

    public void runStoriesAsClasses(List<? extends Class<? extends RunnableStory>> storyClasses) {
        ArrayList<String> storyPaths = new ArrayList<String>();
        StoryPathResolver resolver = this.configuration().storyPathResolver();
        for (Class<? extends RunnableStory> clazz : storyClasses) {
            storyPaths.add(resolver.resolve(clazz));
        }
        this.runStoriesAsPaths(storyPaths);
    }

    public void buildReporters(Configuration configuration, List<String> storyPaths) {
        StoryReporterBuilder reporterBuilder = configuration.storyReporterBuilder();
        configuration.useStoryReporters(reporterBuilder.build(storyPaths));
    }

    public void runStoriesAsPaths(List<String> storyPaths) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesNotRun();
            return;
        }
        HashMap<String, Throwable> failedStories = new HashMap<String, Throwable>();
        Configuration configuration = this.configuration();
        this.buildReporters(configuration, storyPaths);
        for (String storyPath : storyPaths) {
            try {
                this.embedderMonitor.runningStory(storyPath);
                this.storyRunner.run(configuration, this.candidateSteps(), storyPath);
            }
            catch (Throwable e) {
                if (embedderControls.batch()) {
                    failedStories.put(storyPath, e);
                    continue;
                }
                if (embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(storyPath, e);
                    continue;
                }
                throw new RunningStoriesFailedException("Failed to run story " + storyPath, e);
            }
        }
        if (embedderControls.batch() && failedStories.size() > 0) {
            if (embedderControls.ignoreFailureInStories()) {
                this.embedderMonitor.storiesBatchFailed(this.format(failedStories));
            } else {
                throw new RunningStoriesFailedException("Failed to run stories in batch: " + this.format(failedStories));
            }
        }
        if (embedderControls.generateViewAfterStories()) {
            this.generateStoriesView();
        }
    }

    public void generateStoriesView() {
        StoryReporterBuilder builder = this.configuration().storyReporterBuilder();
        File outputDirectory = builder.outputDirectory();
        List<String> formatNames = builder.formatNames(true);
        this.generateStoriesView(outputDirectory, formatNames, builder.viewResources());
    }

    public void generateStoriesView(File outputDirectory, List<String> formats, Properties viewResources) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesViewNotGenerated();
            return;
        }
        ViewGenerator viewGenerator = this.configuration().viewGenerator();
        try {
            this.embedderMonitor.generatingStoriesView(outputDirectory, formats, viewResources);
            viewGenerator.generateView(outputDirectory, formats, viewResources);
        }
        catch (RuntimeException e) {
            this.embedderMonitor.storiesViewGenerationFailed(outputDirectory, formats, viewResources, e);
            String message = "Failed to render reports to " + outputDirectory + " with formats " + formats + " and rendering resources " + viewResources;
            throw new RenderingReportsFailedException(message, e);
        }
        int scenarios = viewGenerator.countScenarios();
        int failedScenarios = viewGenerator.countFailedScenarios();
        this.embedderMonitor.storiesViewGenerated(scenarios, failedScenarios);
        if (!embedderControls.ignoreFailureInReports() && failedScenarios > 0) {
            String message = "Rendered reports with " + scenarios + " scenarios (of which " + failedScenarios + " failed)";
            throw new RunningStoriesFailedException(message);
        }
    }

    public void findMatchingCandidates(String stepAsString) {
        Configuration configuration = this.configuration();
        List<CandidateSteps> candidateSteps = this.candidateSteps();
        CandidateStepFinder finder = configuration.candidateStepFinder();
        CandidateStepReporter reporter = configuration.candidateStepReporter();
        List<CandidateStep> matching = finder.findMatching(stepAsString, candidateSteps);
        List<Object> stepsInstances = finder.stepsInstances(candidateSteps);
        reporter.candidateStepsMatching(stepAsString, matching, stepsInstances);
    }

    public void generateStepdoc() {
        Configuration configuration = this.configuration();
        List<CandidateSteps> candidateSteps = this.candidateSteps();
        StepdocGenerator generator = configuration.stepdocGenerator();
        StepdocReporter reporter = configuration.stepdocReporter();
        reporter.report(generator.generate(candidateSteps.toArray(new CandidateSteps[candidateSteps.size()])));
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<CandidateSteps> candidateSteps() {
        return this.candidateSteps;
    }

    public EmbedderControls embedderControls() {
        return this.configuration().embedderControls();
    }

    public EmbedderMonitor embedderMonitor() {
        return this.embedderMonitor;
    }

    public StoryRunner storyRunner() {
        return this.storyRunner;
    }

    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void useCandidateSteps(List<CandidateSteps> candidateSteps) {
        this.candidateSteps = candidateSteps;
    }

    public void useEmbedderControls(EmbedderControls embedderControls) {
        this.configuration().useEmbedderControls(embedderControls);
    }

    public void useEmbedderMonitor(EmbedderMonitor embedderMonitor) {
        this.embedderMonitor = embedderMonitor;
    }

    public void useStoryRunner(StoryRunner storyRunner) {
        this.storyRunner = storyRunner;
    }

    private String format(Map<String, Throwable> failedStories) {
        StringBuffer sb = new StringBuffer();
        for (String storyName : failedStories.keySet()) {
            Throwable cause = failedStories.get(storyName);
            sb.append("\n");
            sb.append(storyName);
            sb.append(": ");
            sb.append(cause.getMessage());
        }
        return sb.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public class RenderingReportsFailedException
    extends RuntimeException {
        public RenderingReportsFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class RunningStoriesFailedException
    extends RuntimeException {
        public RunningStoriesFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public RunningStoriesFailedException(String message) {
            super(message);
        }
    }
}

