/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.i18n.StringCoder;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keywords {
    public static final String NARRATIVE = "Narrative";
    public static final String IN_ORDER_TO = "InOrderTo";
    public static final String AS_A = "AsA";
    public static final String I_WANT_TO = "IWantTo";
    public static final String SCENARIO = "Scenario";
    public static final String GIVEN_STORIES = "GivenStories";
    public static final String EXAMPLES_TABLE = "ExamplesTable";
    public static final String EXAMPLES_TABLE_ROW = "ExamplesTableRow";
    public static final String EXAMPLES_TABLE_HEADER_SEPARATOR = "ExamplesTableHeaderSeparator";
    public static final String EXAMPLES_TABLE_VALUE_SEPARATOR = "ExamplesTableValueSeparator";
    public static final String GIVEN = "Given";
    public static final String WHEN = "When";
    public static final String THEN = "Then";
    public static final String AND = "And";
    public static final String IGNORABLE = "Ignorable";
    public static final String PENDING = "Pending";
    public static final String NOT_PERFORMED = "NotPerformed";
    public static final String FAILED = "Failed";
    public static final String DRY_RUN = "DryRun";
    public static final List<String> KEYWORDS = Arrays.asList("Narrative", "InOrderTo", "AsA", "IWantTo", "Scenario", "GivenStories", "ExamplesTable", "ExamplesTableRow", "ExamplesTableHeaderSeparator", "ExamplesTableValueSeparator", "Given", "When", "Then", "And", "Ignorable", "Pending", "NotPerformed", "Failed", "DryRun");
    private final String narrative;
    private final String inOrderTo;
    private final String asA;
    private final String iWantTo;
    private final String scenario;
    private final String givenStories;
    private final String examplesTable;
    private final String examplesTableRow;
    private final String examplesTableHeaderSeparator;
    private final String examplesTableValueSeparator;
    private final String given;
    private final String when;
    private final String then;
    private final String and;
    private final String ignorable;
    private final String pending;
    private final String notPerformed;
    private final String failed;
    private final String dryRun;
    private final String[] others;
    private StringCoder encoder;

    public static Map<String, String> defaultKeywords() {
        HashMap<String, String> keywords = new HashMap<String, String>();
        keywords.put(NARRATIVE, "Narrative:");
        keywords.put(IN_ORDER_TO, "In order to:");
        keywords.put(AS_A, "As a:");
        keywords.put(I_WANT_TO, "I want to:");
        keywords.put(SCENARIO, "Scenario:");
        keywords.put(GIVEN_STORIES, "GivenStories:");
        keywords.put(EXAMPLES_TABLE, "Examples:");
        keywords.put(EXAMPLES_TABLE_ROW, "Example:");
        keywords.put(EXAMPLES_TABLE_HEADER_SEPARATOR, "|");
        keywords.put(EXAMPLES_TABLE_VALUE_SEPARATOR, "|");
        keywords.put(GIVEN, GIVEN);
        keywords.put(WHEN, WHEN);
        keywords.put(THEN, THEN);
        keywords.put(AND, AND);
        keywords.put(IGNORABLE, "!--");
        keywords.put(PENDING, "PENDING");
        keywords.put(NOT_PERFORMED, "NOT PERFORMED");
        keywords.put(FAILED, "FAILED");
        keywords.put(DRY_RUN, "DRY RUN");
        return keywords;
    }

    public Keywords() {
        this(Keywords.defaultKeywords());
    }

    public Keywords(Map<String, String> keywords) {
        this(keywords, new StringCoder());
    }

    public Keywords(Map<String, String> keywords, StringCoder encoder) {
        this.narrative = this.keyword(NARRATIVE, keywords);
        this.inOrderTo = this.keyword(IN_ORDER_TO, keywords);
        this.asA = this.keyword(AS_A, keywords);
        this.iWantTo = this.keyword(I_WANT_TO, keywords);
        this.scenario = this.keyword(SCENARIO, keywords);
        this.givenStories = this.keyword(GIVEN_STORIES, keywords);
        this.examplesTable = this.keyword(EXAMPLES_TABLE, keywords);
        this.examplesTableRow = this.keyword(EXAMPLES_TABLE_ROW, keywords);
        this.examplesTableHeaderSeparator = this.keyword(EXAMPLES_TABLE_HEADER_SEPARATOR, keywords);
        this.examplesTableValueSeparator = this.keyword(EXAMPLES_TABLE_VALUE_SEPARATOR, keywords);
        this.given = this.keyword(GIVEN, keywords);
        this.when = this.keyword(WHEN, keywords);
        this.then = this.keyword(THEN, keywords);
        this.and = this.keyword(AND, keywords);
        this.ignorable = this.keyword(IGNORABLE, keywords);
        this.pending = this.keyword(PENDING, keywords);
        this.notPerformed = this.keyword(NOT_PERFORMED, keywords);
        this.failed = this.keyword(FAILED, keywords);
        this.dryRun = this.keyword(DRY_RUN, keywords);
        this.others = new String[]{this.and, this.ignorable};
        this.encoder = encoder;
    }

    private String keyword(String name, Map<String, String> keywords) {
        String keyword = keywords.get(name);
        if (keyword == null) {
            throw new KeywordNotFoundException(name, keywords);
        }
        return keyword;
    }

    public String narrative() {
        return this.narrative;
    }

    public String inOrderTo() {
        return this.inOrderTo;
    }

    public String asA() {
        return this.asA;
    }

    public String iWantTo() {
        return this.iWantTo;
    }

    public String scenario() {
        return this.scenario;
    }

    public String givenStories() {
        return this.givenStories;
    }

    public String examplesTable() {
        return this.examplesTable;
    }

    public String examplesTableRow() {
        return this.examplesTableRow;
    }

    public String examplesTableHeaderSeparator() {
        return this.examplesTableHeaderSeparator;
    }

    public String examplesTableValueSeparator() {
        return this.examplesTableValueSeparator;
    }

    public String given() {
        return this.given;
    }

    public String when() {
        return this.when;
    }

    public String then() {
        return this.then;
    }

    public String and() {
        return this.and;
    }

    public String ignorable() {
        return this.ignorable;
    }

    public String pending() {
        return this.pending;
    }

    public String notPerformed() {
        return this.notPerformed;
    }

    public String failed() {
        return this.failed;
    }

    public String dryRun() {
        return this.dryRun;
    }

    public String[] others() {
        return this.others;
    }

    public String encode(String value) {
        if (this.encoder != null) {
            return this.encoder.canonicalize(value);
        }
        return value;
    }

    public Map<StepType, String> startingWordsByType() {
        HashMap<StepType, String> words = new HashMap<StepType, String>();
        words.put(StepType.GIVEN, this.given());
        words.put(StepType.WHEN, this.when());
        words.put(StepType.THEN, this.then());
        words.put(StepType.AND, this.and());
        words.put(StepType.IGNORABLE, this.ignorable());
        return words;
    }

    public static final class InsufficientKeywordsException
    extends RuntimeException {
        public InsufficientKeywordsException(String ... others) {
            super("Insufficient keywords: " + Arrays.asList(others) + ", but requires another " + (11 - others.length));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeywordNotFoundException
    extends RuntimeException {
        public KeywordNotFoundException(String name, Map<String, String> keywords) {
            super("Keyword " + name + " not found amongst " + keywords);
        }
    }
}

