/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.RethrowingFailure;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.io.UnderscoredCamelCaseResolver;
import org.jbehave.core.parsers.RegexPrefixCapturingPatternParser;
import org.jbehave.core.parsers.RegexStoryParser;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.reporters.CandidateStepReporter;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.PrintStreamCandidateStepReporter;
import org.jbehave.core.reporters.PrintStreamStepdocReporter;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.CandidateStepFinder;
import org.jbehave.core.steps.DefaultStepdocGenerator;
import org.jbehave.core.steps.MarkUnmatchedStepsAsPending;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepdocGenerator;
import org.jbehave.paranamer.NullParanamer;
import org.jbehave.paranamer.Paranamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private CandidateStepFinder candidateStepFinder = new CandidateStepFinder();
    private CandidateStepReporter candidateStepReporter = new PrintStreamCandidateStepReporter();
    private boolean dryRun = false;
    private Keywords keywords = new LocalizedKeywords();
    private StepCollector stepCollector = new MarkUnmatchedStepsAsPending();
    private StoryParser storyParser = new RegexStoryParser(this.keywords);
    private StoryLoader storyLoader = new LoadFromClasspath();
    private StoryPathResolver storyPathResolver = new UnderscoredCamelCaseResolver();
    private FailureStrategy failureStrategy = new RethrowingFailure();
    private PendingStepStrategy pendingStepStrategy = new PassingUponPendingStep();
    private StoryReporter defaultStoryReporter = new ConsoleOutput();
    private Map<String, StoryReporter> storyReporters = new HashMap<String, StoryReporter>();
    private StoryReporterBuilder storyReporterBuilder = new StoryReporterBuilder();
    private StepPatternParser stepPatternParser = new RegexPrefixCapturingPatternParser();
    private StepMonitor stepMonitor = new SilentStepMonitor();
    private Paranamer paranamer = new NullParanamer();
    private ParameterConverters parameterConverters = new ParameterConverters();
    private StepdocGenerator stepdocGenerator = new DefaultStepdocGenerator();
    private StepdocReporter stepdocReporter = new PrintStreamStepdocReporter();
    private ViewGenerator viewGenerator = new FreemarkerViewGenerator();
    private EmbedderControls embedderControls = new EmbedderControls();

    public CandidateStepFinder candidateStepFinder() {
        return this.candidateStepFinder;
    }

    public CandidateStepReporter candidateStepReporter() {
        return this.candidateStepReporter;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    public Keywords keywords() {
        return this.keywords;
    }

    public StepCollector stepCollector() {
        return this.stepCollector;
    }

    public StoryParser storyParser() {
        return this.storyParser;
    }

    public StoryLoader storyLoader() {
        return this.storyLoader;
    }

    public StoryPathResolver storyPathResolver() {
        return this.storyPathResolver;
    }

    public FailureStrategy failureStrategy() {
        return this.failureStrategy;
    }

    public PendingStepStrategy pendingStepStrategy() {
        return this.pendingStepStrategy;
    }

    public StoryReporter defaultStoryReporter() {
        return this.defaultStoryReporter;
    }

    public StoryReporter storyReporter(String storyPath) {
        StoryReporter storyReporter = this.storyReporters.get(storyPath);
        if (storyReporter != null) {
            return storyReporter;
        }
        return this.defaultStoryReporter();
    }

    public StoryReporterBuilder storyReporterBuilder() {
        return this.storyReporterBuilder;
    }

    public StepPatternParser stepPatternParser() {
        return this.stepPatternParser;
    }

    public StepMonitor stepMonitor() {
        return this.stepMonitor;
    }

    public Paranamer paranamer() {
        return this.paranamer;
    }

    public ParameterConverters parameterConverters() {
        return this.parameterConverters;
    }

    public StepdocGenerator stepdocGenerator() {
        return this.stepdocGenerator;
    }

    public StepdocReporter stepdocReporter() {
        return this.stepdocReporter;
    }

    public ViewGenerator viewGenerator() {
        return this.viewGenerator;
    }

    public EmbedderControls embedderControls() {
        return this.embedderControls;
    }

    public void useCandidateStepFinder(CandidateStepFinder candidateStepFinder) {
        this.candidateStepFinder = candidateStepFinder;
    }

    public void useCandidateStepReporter(CandidateStepReporter candidateStepReporter) {
        this.candidateStepReporter = candidateStepReporter;
    }

    public void doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Configuration useKeywords(Keywords keywords) {
        this.keywords = keywords;
        return this;
    }

    public Configuration useStepCollector(StepCollector stepCollector) {
        this.stepCollector = stepCollector;
        return this;
    }

    public Configuration usePendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        this.pendingStepStrategy = pendingStepStrategy;
        return this;
    }

    public Configuration useFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
        return this;
    }

    public Configuration useStoryParser(StoryParser storyParser) {
        this.storyParser = storyParser;
        return this;
    }

    public Configuration useStoryLoader(StoryLoader storyLoader) {
        this.storyLoader = storyLoader;
        return this;
    }

    public Configuration useStoryPathResolver(StoryPathResolver storyPathResolver) {
        this.storyPathResolver = storyPathResolver;
        return this;
    }

    public Configuration useDefaultStoryReporter(StoryReporter storyReporter) {
        this.defaultStoryReporter = storyReporter;
        return this;
    }

    public Configuration useStoryReporter(String storyPath, StoryReporter storyReporter) {
        this.storyReporters.put(storyPath, storyReporter);
        return this;
    }

    public Configuration useStoryReporters(Map<String, StoryReporter> storyReporters) {
        this.storyReporters.putAll(storyReporters);
        return this;
    }

    public Configuration useStoryReporterBuilder(StoryReporterBuilder storyReporterBuilder) {
        this.storyReporterBuilder = storyReporterBuilder;
        return this;
    }

    public Configuration useEmbedderControls(EmbedderControls embedderControls) {
        this.embedderControls = embedderControls;
        return this;
    }

    public Configuration useStepPatternParser(StepPatternParser stepPatternParser) {
        this.stepPatternParser = stepPatternParser;
        return this;
    }

    public Configuration useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        return this;
    }

    public Configuration useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
        return this;
    }

    public Configuration useParameterConverters(ParameterConverters parameterConverters) {
        this.parameterConverters = parameterConverters;
        return this;
    }

    public void useStepdocGenerator(StepdocGenerator stepdocGenerator) {
        this.stepdocGenerator = stepdocGenerator;
    }

    public void useStepdocReporter(StepdocReporter stepdocReporter) {
        this.stepdocReporter = stepdocReporter;
    }

    public void useViewGenerator(ViewGenerator viewGenerator) {
        this.viewGenerator = viewGenerator;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

