/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.RunnableStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryClassLoader
extends URLClassLoader {
    public StoryClassLoader(List<String> classpathElements) throws MalformedURLException {
        this(classpathElements, RunnableStory.class.getClassLoader());
    }

    public StoryClassLoader(List<String> classpathElements, ClassLoader parent) throws MalformedURLException {
        super(StoryClassLoader.classpathURLs(classpathElements), parent);
    }

    public RunnableStory newStory(String storyClassName, Class<?> ... parameterTypes) {
        Class<?> storyClass = this.loadStoryClass(storyClassName);
        Thread.currentThread().setContextClassLoader(this);
        return this.instantiateStory(storyClass, parameterTypes);
    }

    public Class<?> loadStoryClass(String storyClassName) {
        try {
            return this.loadClass(storyClassName, true);
        }
        catch (ClassNotFoundException e) {
            throw new StoryClassNotFoundException(storyClassName, e);
        }
    }

    public RunnableStory instantiateStory(Class<?> storyClass, Class<?> ... parameterTypes) {
        try {
            return this.newInstance(storyClass, parameterTypes);
        }
        catch (Exception e) {
            throw new StoryNotInstantiatedException(storyClass, Arrays.asList(parameterTypes), e);
        }
    }

    private RunnableStory newInstance(Class<?> storyClass, Class<?> ... parameterTypes) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (parameterTypes.length > 0 && parameterTypes[0].equals(ClassLoader.class)) {
            Constructor<?> constructor = storyClass.getConstructor(parameterTypes);
            return (RunnableStory)constructor.newInstance(this);
        }
        return (RunnableStory)storyClass.newInstance();
    }

    private List<String> asShortPaths(URL[] urls) {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : urls) {
            String path = url.getPath();
            if (StoryClassLoader.isJar(path)) {
                names.add(StoryClassLoader.shortPath(path));
                continue;
            }
            names.add(path);
        }
        return names;
    }

    private static String shortPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static boolean isJar(String path) {
        return path.endsWith(".jar");
    }

    private static URL[] classpathURLs(List<String> elements) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (elements != null) {
            for (String element : elements) {
                urls.add(new File(element).toURL());
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public String toString() {
        return "[" + StoryClassLoader.class.getName() + " urls=" + this.asShortPaths(this.getURLs()) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StoryNotInstantiatedException
    extends RuntimeException {
        public StoryNotInstantiatedException(Class<?> storyClass, List<Class<?>> parameterTypes, Throwable cause) {
            super("Story not instantiated for class  " + storyClass + " and parameters  " + parameterTypes, cause);
        }
    }

    public static class StoryClassNotFoundException
    extends RuntimeException {
        public StoryClassNotFoundException(String storyClassName, Throwable cause) {
            super("Story not found for class " + storyClassName, cause);
        }
    }
}

