/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.RunnableStory;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.UnmodifiableEmbedderControls;
import org.jbehave.core.steps.CandidateSteps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStory
implements RunnableStory {
    private Configuration configuration = new MostUsefulConfiguration();
    private List<CandidateSteps> candidateSteps = new ArrayList<CandidateSteps>();
    private Embedder embedder = new Embedder();

    @Override
    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void addSteps(CandidateSteps ... steps) {
        this.addSteps(Arrays.asList(steps));
    }

    @Override
    public void addSteps(List<CandidateSteps> steps) {
        this.candidateSteps.addAll(steps);
    }

    @Override
    public void useEmbedder(Embedder embedder) {
        this.embedder = embedder;
    }

    protected Configuration configuration() {
        return this.configuration;
    }

    protected List<CandidateSteps> candidateSteps() {
        return this.candidateSteps;
    }

    protected Embedder configuredEmbedder() {
        Configuration configuration = this.configuration();
        List<CandidateSteps> candidateSteps = this.candidateSteps();
        EmbedderControls embedderControls = this.embedder.embedderControls();
        if (embedderControls instanceof UnmodifiableEmbedderControls) {
            configuration.useEmbedderControls(embedderControls);
        }
        this.embedder.useConfiguration(configuration);
        this.embedder.useCandidateSteps(candidateSteps);
        return this.embedder;
    }
}

