/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import org.jbehave.scenario.parser.PrefixCapturingPatternBuilder;
import org.jbehave.scenario.parser.StepPatternBuilder;
import org.jbehave.scenario.steps.ParameterConverters;
import org.jbehave.scenario.steps.SilentStepMonitor;
import org.jbehave.scenario.steps.StepMonitor;

public class StepsConfiguration {
    public static final String[] DEFAULT_STARTING_WORDS = new String[]{"Given", "When", "Then", "And"};
    private StepPatternBuilder patternBuilder;
    private StepMonitor monitor;
    private ParameterConverters parameterConverters;
    private String[] startingWords;

    public StepsConfiguration() {
        this(DEFAULT_STARTING_WORDS);
    }

    public StepsConfiguration(String ... startingWords) {
        this(new PrefixCapturingPatternBuilder(), new SilentStepMonitor(), new ParameterConverters(), startingWords);
    }

    public StepsConfiguration(StepPatternBuilder patternBuilder, StepMonitor monitor, ParameterConverters parameterConverters, String ... startingWords) {
        this.patternBuilder = patternBuilder;
        this.monitor = monitor;
        this.parameterConverters = parameterConverters;
        this.startingWords = startingWords;
    }

    public StepsConfiguration(ParameterConverters converters) {
        this(new PrefixCapturingPatternBuilder(), new SilentStepMonitor(), converters, DEFAULT_STARTING_WORDS);
    }

    public StepPatternBuilder getPatternBuilder() {
        return this.patternBuilder;
    }

    public void usePatternBuilder(StepPatternBuilder patternBuilder) {
        this.patternBuilder = patternBuilder;
    }

    public StepMonitor getMonitor() {
        return this.monitor;
    }

    public void useMonitor(StepMonitor monitor) {
        this.monitor = monitor;
    }

    public ParameterConverters getParameterConverters() {
        return this.parameterConverters;
    }

    public void useParameterConverters(ParameterConverters parameterConverters) {
        this.parameterConverters = parameterConverters;
    }

    public String[] getStartingWords() {
        return this.startingWords;
    }

    public void useStartingWords(String ... startingWords) {
        this.startingWords = startingWords;
    }
}

