/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.scenario.annotations.AfterScenario;
import org.jbehave.scenario.annotations.Aliases;
import org.jbehave.scenario.annotations.BeforeScenario;
import org.jbehave.scenario.annotations.Given;
import org.jbehave.scenario.annotations.Then;
import org.jbehave.scenario.annotations.When;
import org.jbehave.scenario.errors.BeforeOrAfterScenarioException;
import org.jbehave.scenario.reporters.ScenarioReporter;
import org.jbehave.scenario.steps.CandidateStep;
import org.jbehave.scenario.steps.CandidateSteps;
import org.jbehave.scenario.steps.ParameterConverters;
import org.jbehave.scenario.steps.Step;
import org.jbehave.scenario.steps.StepResult;
import org.jbehave.scenario.steps.StepsConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Steps
implements CandidateSteps {
    private final StepsConfiguration configuration;

    public Steps() {
        this(new StepsConfiguration());
    }

    public Steps(String ... startingWords) {
        this(new StepsConfiguration(startingWords));
    }

    public Steps(ParameterConverters converters) {
        this(new StepsConfiguration(converters));
    }

    public Steps(StepsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CandidateStep[] getSteps() {
        return this.getSteps(this.getClass());
    }

    @Override
    public CandidateStep[] getSteps(Class<?> stepsClass) {
        ArrayList<CandidateStep> steps = new ArrayList<CandidateStep>();
        for (Method method : stepsClass.getMethods()) {
            String value;
            if (method.isAnnotationPresent(Given.class)) {
                value = method.getAnnotation(Given.class).value();
                this.createCandidateStep(steps, method, value);
                this.createCandidateStepsFromAliases(steps, method);
            }
            if (method.isAnnotationPresent(When.class)) {
                value = method.getAnnotation(When.class).value();
                this.createCandidateStep(steps, method, value);
                this.createCandidateStepsFromAliases(steps, method);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            value = method.getAnnotation(Then.class).value();
            this.createCandidateStep(steps, method, value);
            this.createCandidateStepsFromAliases(steps, method);
        }
        return steps.toArray(new CandidateStep[steps.size()]);
    }

    void createCandidateStep(List<CandidateStep> steps, Method method, String stepAsString) {
        this.checkForDuplicateCandidateSteps(steps, stepAsString);
        steps.add(new CandidateStep(stepAsString, method, this, this.configuration.getPatternBuilder(), this.configuration.getMonitor(), this.configuration.getParameterConverters(), this.configuration.getStartingWords()));
    }

    private void checkForDuplicateCandidateSteps(List<CandidateStep> steps, String stepAsString) {
        for (CandidateStep step : steps) {
            if (!step.getStepAsString().equals(stepAsString)) continue;
            throw new DuplicateCandidateStepFoundException(stepAsString);
        }
    }

    private void createCandidateStepsFromAliases(List<CandidateStep> steps, Method method) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.createCandidateStep(steps, method, alias);
            }
        }
    }

    public List<Step> runBeforeScenario() {
        return this.stepsHaving(BeforeScenario.class, new OkayToRun());
    }

    public List<Step> runAfterScenario() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.addAll(this.stepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.ANY, new OkayToRun(), new OkayToRun()));
        steps.addAll(this.stepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.SUCCESS, new OkayToRun(), new DoNotRun()));
        steps.addAll(this.stepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.FAILURE, new DoNotRun(), new OkayToRun()));
        return steps;
    }

    private List<Step> stepsHaving(final Class<? extends Annotation> annotationClass, final StepPart forScenarios) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (final Method method : this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            steps.add(new Step(){

                public StepResult doNotPerform() {
                    return forScenarios.run(annotationClass, method);
                }

                public StepResult perform() {
                    return forScenarios.run(annotationClass, method);
                }
            });
        }
        return steps;
    }

    private List<Step> stepsHavingOutcome(final Class<? extends AfterScenario> annotationClass, AfterScenario.Outcome outcome, final StepPart forSuccessfulScenarios, final StepPart forUnsuccessfulScenarios) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (final Method method : this.getClass().getMethods()) {
            AfterScenario annotation;
            if (!method.isAnnotationPresent(annotationClass) || !outcome.equals((Object)(annotation = method.getAnnotation(annotationClass)).uponOutcome())) continue;
            steps.add(new Step(){

                public StepResult doNotPerform() {
                    return forUnsuccessfulScenarios.run(annotationClass, method);
                }

                public StepResult perform() {
                    return forSuccessfulScenarios.run(annotationClass, method);
                }
            });
        }
        return steps;
    }

    public static class DuplicateCandidateStepFoundException
    extends RuntimeException {
        public DuplicateCandidateStepFoundException(String message) {
            super(message);
        }
    }

    public class SilentStepResult
    extends StepResult {
        public SilentStepResult() {
            super("");
        }

        public void describeTo(ScenarioReporter reporter) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StepPart {
        public StepResult run(Class<? extends Annotation> var1, Method var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoNotRun
    implements StepPart {
        private DoNotRun() {
        }

        @Override
        public StepResult run(Class<? extends Annotation> annotation, Method method) {
            return new SilentStepResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OkayToRun
    implements StepPart {
        private OkayToRun() {
        }

        @Override
        public StepResult run(Class<? extends Annotation> annotation, Method method) {
            try {
                method.invoke((Object)Steps.this, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw new BeforeOrAfterScenarioException(annotation, method, e.getCause());
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return new SilentStepResult();
        }
    }
}

