/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import org.jbehave.scenario.errors.PendingError;
import org.jbehave.scenario.reporters.ScenarioReporter;

public abstract class StepResult {
    protected final String step;
    protected final Throwable throwable;

    public StepResult(String step) {
        this(step, null);
    }

    public StepResult(String step, Throwable throwable) {
        this.step = step;
        this.throwable = throwable;
    }

    public static StepResult success(String step) {
        return new Success(step);
    }

    public static StepResult pending(String step) {
        return new Pending(step);
    }

    public static StepResult pending(String step, PendingError e) {
        return new Pending(step, e);
    }

    public static StepResult notPerformed(String step) {
        return new NotPerformed(step);
    }

    public static StepResult failure(String step, Throwable e) {
        return new Failed(step, e);
    }

    public abstract void describeTo(ScenarioReporter var1);

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static class Success
    extends StepResult {
        public Success(String string) {
            super(string);
        }

        public void describeTo(ScenarioReporter reporter) {
            reporter.successful(this.step);
        }
    }

    public static class Pending
    extends StepResult {
        public Pending(String step) {
            this(step, new PendingError(step));
        }

        public Pending(String step, PendingError e) {
            super(step, (Throwable)((Object)e));
        }

        public void describeTo(ScenarioReporter reporter) {
            reporter.pending(this.step);
        }
    }

    public static class NotPerformed
    extends StepResult {
        public NotPerformed(String step) {
            super(step);
        }

        public void describeTo(ScenarioReporter reporter) {
            reporter.notPerformed(this.step);
        }
    }

    public static class Failed
    extends StepResult {
        public Failed(String step, Throwable throwable) {
            super(step, throwable);
        }

        public void describeTo(ScenarioReporter reporter) {
            reporter.failed(this.step, this.throwable);
        }
    }
}

