/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import java.io.PrintStream;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import org.jbehave.scenario.steps.StepMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamStepMonitor
implements StepMonitor {
    private static final String CONVERTED_VALUE_OF_TYPE = "Converted value ''{0}'' of type ''{1}'' to ''{2}'' with converter ''{3}''";
    private static final String STEP_MATCHES_PATTERN = "Step ''{0}'' {1} pattern ''{2}''";
    private static final String MATCHES = "matches";
    private static final String DOES_NOT_MATCH = "does not match";
    private final PrintStream output;

    public PrintStreamStepMonitor() {
        this(System.out);
    }

    public PrintStreamStepMonitor(PrintStream output) {
        this.output = output;
    }

    @Override
    public void stepMatchesPattern(String step, boolean matches, String pattern) {
        String message = MessageFormat.format(STEP_MATCHES_PATTERN, step, matches ? MATCHES : DOES_NOT_MATCH, pattern);
        this.print(this.output, message);
    }

    @Override
    public void convertedValueOfType(String value, Type type, Object converted, Class<?> converterClass) {
        String message = MessageFormat.format(CONVERTED_VALUE_OF_TYPE, value, type, converted, converterClass);
        this.print(this.output, message);
    }

    @Override
    public void performing(String step) {
        this.print(this.output, step);
    }

    protected void print(PrintStream output, String message) {
        output.println(message);
    }
}

