/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.scenario.steps.SilentStepMonitor;
import org.jbehave.scenario.steps.StepMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterConverters {
    private static final String NEWLINES_PATTERN = "(\n)|(\r\n)";
    private static final String SYSTEM_NEWLINE = System.getProperty("line.separator");
    private static final String COMMA = ",";
    private static final List<ParameterConverter> DEFAULT_CONVERTERS = Arrays.asList(new NumberConverter(), new NumberListConverter(), new StringListConverter());
    private final StepMonitor monitor;
    private final List<ParameterConverter> converters = new ArrayList<ParameterConverter>();

    public ParameterConverters() {
        this(new SilentStepMonitor(), new ParameterConverter[0]);
    }

    public ParameterConverters(ParameterConverter ... customConverters) {
        this(new SilentStepMonitor(), customConverters);
    }

    public ParameterConverters(StepMonitor monitor, ParameterConverter ... customConverters) {
        this.monitor = monitor;
        this.converters.addAll(Arrays.asList(customConverters));
        this.converters.addAll(DEFAULT_CONVERTERS);
    }

    public Object convert(String value, Type type) {
        for (ParameterConverter converter : this.converters) {
            if (!converter.accept(type)) continue;
            Object converted = converter.convertValue(value, type);
            this.monitor.convertedValueOfType(value, type, converted, converter.getClass());
            return converted;
        }
        return this.replaceNewlinesWithSystemNewlines(value);
    }

    private Object replaceNewlinesWithSystemNewlines(String value) {
        return value.replaceAll(NEWLINES_PATTERN, SYSTEM_NEWLINE);
    }

    public static List<String> trim(List<String> values) {
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String value : values) {
            trimmed.add(value.trim());
        }
        return trimmed;
    }

    public static class StringListConverter
    implements ParameterConverter {
        private String valueSeparator;

        public StringListConverter() {
            this(ParameterConverters.COMMA);
        }

        public StringListConverter(String valueSeparator) {
            this.valueSeparator = valueSeparator;
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                Type argumentType = parameterizedType.getActualTypeArguments()[0];
                return List.class.isAssignableFrom((Class)rawType) && String.class.isAssignableFrom((Class)argumentType);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            return ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        }
    }

    public static class NumberListConverter
    implements ParameterConverter {
        private NumberFormat numberFormat;
        private String valueSeparator;

        public NumberListConverter() {
            this(NumberFormat.getInstance(), ParameterConverters.COMMA);
        }

        public NumberListConverter(NumberFormat numberFormat, String valueSeparator) {
            this.numberFormat = numberFormat;
            this.valueSeparator = valueSeparator;
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                Type argumentType = parameterizedType.getActualTypeArguments()[0];
                return List.class.isAssignableFrom((Class)rawType) && Number.class.isAssignableFrom((Class)argumentType);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            List<String> values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
            ArrayList<Number> numbers = new ArrayList<Number>();
            for (String numberValue : values) {
                try {
                    numbers.add(this.numberFormat.parse(numberValue));
                }
                catch (ParseException e) {
                    throw new InvalidParameterException(numberValue, e);
                }
            }
            return numbers;
        }
    }

    public static class NumberConverter
    implements ParameterConverter {
        private static List<Class> acceptedClasses = Arrays.asList(Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE);

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return acceptedClasses.contains(type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (type == Long.class || type == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (type == Double.class || type == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(value);
            }
            return value;
        }
    }

    public static class InvalidParameterException
    extends RuntimeException {
        public InvalidParameterException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ParameterConverter {
        public boolean accept(Type var1);

        public Object convertValue(String var1, Type var2);
    }
}

