/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.steps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.scenario.errors.PendingError;
import org.jbehave.scenario.parser.StepPatternBuilder;
import org.jbehave.scenario.steps.CandidateSteps;
import org.jbehave.scenario.steps.ParameterConverters;
import org.jbehave.scenario.steps.Step;
import org.jbehave.scenario.steps.StepMonitor;
import org.jbehave.scenario.steps.StepResult;

public class CandidateStep {
    private final String stepAsString;
    private final Method method;
    private final CandidateSteps steps;
    private final StepMonitor stepMonitor;
    private final ParameterConverters parameterConverters;
    private final String[] startingWords;
    private final Pattern pattern;

    public CandidateStep(String stepAsString, Method method, CandidateSteps steps, StepPatternBuilder patterBuilder, StepMonitor stepMonitor, ParameterConverters parameterConverters, String ... startingWords) {
        this.stepAsString = stepAsString;
        this.method = method;
        this.steps = steps;
        this.stepMonitor = stepMonitor;
        this.parameterConverters = parameterConverters;
        this.startingWords = startingWords;
        this.pattern = patterBuilder.buildPattern(stepAsString);
    }

    public boolean matches(String step) {
        String word = this.findStartingWord(step);
        if (word == null) {
            return false;
        }
        String trimmed = this.trimStartingWord(word, step);
        Matcher matcher = this.pattern.matcher(trimmed);
        boolean matches = matcher.matches();
        this.stepMonitor.stepMatchesPattern(step, matches, this.pattern.pattern());
        return matches;
    }

    private String trimStartingWord(String word, String step) {
        return step.substring(word.length() + 1);
    }

    public Step createFrom(String stepAsString) {
        String startingWord = this.findStartingWord(stepAsString);
        Matcher matcher = this.pattern.matcher(this.trimStartingWord(startingWord, stepAsString));
        matcher.find();
        Type[] types = this.method.getGenericParameterTypes();
        Object[] args = new Object[matcher.groupCount()];
        for (int group = 0; group < args.length; ++group) {
            Object converted;
            String arg = matcher.group(group + 1);
            args[group] = converted = this.parameterConverters.convert(arg, types[group]);
        }
        return this.createStep(stepAsString, args);
    }

    private String findStartingWord(String stepAsString) {
        for (String word : this.startingWords) {
            if (!stepAsString.startsWith(word)) continue;
            return word;
        }
        return null;
    }

    private Step createStep(final String stepAsString, final Object[] args) {
        return new Step(){

            public StepResult perform() {
                try {
                    CandidateStep.this.stepMonitor.performing(stepAsString);
                    CandidateStep.this.method.invoke((Object)CandidateStep.this.steps, args);
                    return StepResult.success(stepAsString);
                }
                catch (Throwable t) {
                    return this.failureWithOriginalException(stepAsString, t);
                }
            }

            private StepResult failureWithOriginalException(String stepAsString2, Throwable t) {
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    if (t.getCause() instanceof PendingError) {
                        return StepResult.pending(stepAsString2, (PendingError)((Object)t.getCause()));
                    }
                    return StepResult.failure(stepAsString2, t.getCause());
                }
                return StepResult.failure(stepAsString2, t);
            }

            public StepResult doNotPerform() {
                return StepResult.notPerformed(stepAsString);
            }
        };
    }

    public String getStepAsString() {
        return this.stepAsString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.stepAsString;
    }
}

