/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.reporters;

import java.io.PrintStream;
import org.jbehave.scenario.definition.Blurb;
import org.jbehave.scenario.reporters.ScenarioReporter;

public class PrintStreamScenarioReporter
implements ScenarioReporter {
    private final PrintStream output;
    private final boolean reportErrors;
    private Throwable cause;

    public PrintStreamScenarioReporter() {
        this(System.out);
    }

    public PrintStreamScenarioReporter(PrintStream output) {
        this(output, false);
    }

    public PrintStreamScenarioReporter(PrintStream output, boolean reportErrors) {
        this.output = output;
        this.reportErrors = reportErrors;
    }

    public void successful(String step) {
        this.output.println(step);
    }

    public void pending(String step) {
        this.output.println(step + " (PENDING)");
    }

    public void notPerformed(String step) {
        this.output.println(step + " (NOT PERFORMED)");
    }

    public void failed(String step, Throwable cause) {
        this.cause = cause;
        this.output.println(step + " (FAILED)");
    }

    public void afterScenario() {
        this.output.println();
        if (this.reportErrors && this.cause != null) {
            this.cause.printStackTrace(this.output);
            this.output.println();
        }
    }

    public void beforeScenario(String title) {
        this.cause = null;
        this.output.println("Scenario: " + title);
        this.output.println();
    }

    public void afterStory() {
    }

    public void beforeStory(Blurb blurb) {
        this.output.println(blurb.asString());
        this.output.println();
    }
}

