/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.reporters;

import java.util.ArrayList;
import java.util.List;
import org.jbehave.scenario.definition.Blurb;
import org.jbehave.scenario.reporters.ScenarioReporter;

public class PassSilentlyDecorator
implements ScenarioReporter {
    private final ScenarioReporter delegate;
    private List<Todo> currentScenario;
    private State scenarioState = State.SILENT;
    private State beforeStoryState = State.SILENT;
    private State afterStoryState = State.SILENT;

    public PassSilentlyDecorator(ScenarioReporter delegate) {
        this.delegate = delegate;
    }

    public void afterStory() {
        this.afterStoryState.report();
    }

    public void beforeStory(final Blurb blurb) {
        this.beforeStoryState = new State(){

            public void report() {
                PassSilentlyDecorator.this.delegate.beforeStory(blurb);
                PassSilentlyDecorator.this.beforeStoryState = State.SILENT;
            }
        };
    }

    public void failed(final String step, final Throwable e) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.failed(step, e);
            }
        });
        this.setStateToNoisy();
    }

    public void notPerformed(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.notPerformed(step);
            }
        });
    }

    public void pending(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.pending(step);
            }
        });
        this.setStateToNoisy();
    }

    private void setStateToNoisy() {
        this.scenarioState = new State(){

            public void report() {
                PassSilentlyDecorator.this.beforeStoryState.report();
                for (Todo todo : PassSilentlyDecorator.this.currentScenario) {
                    todo.doNow();
                }
                PassSilentlyDecorator.this.afterStoryState = new State(){

                    public void report() {
                        PassSilentlyDecorator.this.delegate.afterStory();
                        PassSilentlyDecorator.this.afterStoryState = State.SILENT;
                    }
                };
                PassSilentlyDecorator.this.scenarioState = State.SILENT;
            }
        };
    }

    public void successful(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.successful(step);
            }
        });
    }

    public void afterScenario() {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.afterScenario();
            }
        });
        this.scenarioState.report();
    }

    public void beforeScenario(final String title) {
        this.currentScenario = new ArrayList<Todo>();
        this.currentScenario.add(new Todo(){

            public void doNow() {
                PassSilentlyDecorator.this.delegate.beforeScenario(title);
            }
        });
    }

    private static interface State {
        public static final State SILENT = new State(){

            public void report() {
            }
        };

        public void report();
    }

    private static interface Todo {
        public void doNow();
    }
}

