/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.scenario.RunnableScenario;
import org.jbehave.scenario.parser.AbstractScenarioNameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnderscoredCamelCaseResolver
extends AbstractScenarioNameResolver {
    public static final String NUMBERS_AS_LOWER_CASE_LETTERS_PATTERN = "([A-Z].*?)([A-Z]|\\z)";
    public static final String NUMBERS_AS_UPPER_CASE_LETTERS_PATTERN = "([A-Z0-9].*?)([A-Z0-9]|\\z)";
    private static final String UNDERSCORE = "_";
    private final String resolutionPattern;

    public UnderscoredCamelCaseResolver() {
        this("");
    }

    public UnderscoredCamelCaseResolver(String extension) {
        this(extension, NUMBERS_AS_LOWER_CASE_LETTERS_PATTERN);
    }

    public UnderscoredCamelCaseResolver(String extension, String resolutionPattern) {
        super(extension);
        this.resolutionPattern = resolutionPattern;
    }

    @Override
    protected String resolveFileName(Class<? extends RunnableScenario> scenarioClass) {
        Matcher matcher = Pattern.compile(this.resolutionPattern).matcher(scenarioClass.getSimpleName());
        int startAt = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find(startAt)) {
            builder.append(matcher.group(1).toLowerCase());
            builder.append(UNDERSCORE);
            startAt = matcher.start(2);
        }
        return builder.substring(0, builder.length() - 1);
    }
}

