/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.jbehave.scenario.errors.InvalidScenarioClassPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioClassNameFinder {
    private static final String JAVA = ".java";
    private static final String EMPTY = "";
    private static final String DOT_REGEX = "\\.";
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\\\";
    private DirectoryScanner scanner = new DirectoryScanner();

    public List<String> listScenarioClassNames(String basedir, String rootPath, List<String> includes, List<String> excludes) {
        ArrayList<String> classNames = new ArrayList<String>();
        for (String path : this.listPaths(basedir, rootPath, includes, excludes)) {
            classNames.add(this.classNameFor(path));
        }
        return classNames;
    }

    private String classNameFor(String path) {
        int javaPath = path.indexOf(JAVA);
        if (javaPath != -1) {
            String className = path.substring(0, javaPath);
            className = className.replaceAll(SLASH, DOT_REGEX);
            return className.replaceAll(BACKSLASH, DOT_REGEX);
        }
        throw new InvalidScenarioClassPathException("Invalid scenario class path " + path);
    }

    private List<String> listPaths(String basedir, String rootPath, List<String> includes, List<String> excludes) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!new File(basedir).exists()) {
            return paths;
        }
        this.scanner.setBasedir(basedir);
        if (includes != null) {
            this.scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            this.scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        this.scanner.scan();
        String basePath = rootPath != null ? rootPath + SLASH : EMPTY;
        for (String relativePath : this.scanner.getIncludedFiles()) {
            String path = basePath + relativePath;
            paths.add(path);
        }
        return paths;
    }
}

