/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.scenario.parser.StepPatternBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixCapturingPatternBuilder
implements StepPatternBuilder {
    private final String anyWordBeginningWithThePrefix;

    public PrefixCapturingPatternBuilder() {
        this("$");
    }

    public PrefixCapturingPatternBuilder(String prefix) {
        this.anyWordBeginningWithThePrefix = "(\\" + prefix + "\\w*)(\\W|\\Z)";
    }

    @Override
    public Pattern buildPattern(String matchThis) {
        String matchThisButLeaveBrackets = this.escapeRegexpPunctuation(matchThis);
        List<Replacement> replacements = this.findArgumentsToReplace(matchThisButLeaveBrackets);
        String patternToMatchAgainst = this.replaceIdentifiedArgsWithCapture(matchThisButLeaveBrackets, replacements);
        String matchThisButIgnoreWhitespace = this.anyWhitespaceWillDo(patternToMatchAgainst);
        return Pattern.compile(matchThisButIgnoreWhitespace, 32);
    }

    private String anyWhitespaceWillDo(String matchThis) {
        return matchThis.replaceAll("\\s+", "\\\\s+");
    }

    private List<Replacement> findArgumentsToReplace(String matchThisButLeaveBrackets) {
        Matcher findingAllTheDollarWords = Pattern.compile(this.anyWordBeginningWithThePrefix, 32).matcher(matchThisButLeaveBrackets);
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        while (findingAllTheDollarWords.find()) {
            replacements.add(new Replacement(findingAllTheDollarWords.start(), findingAllTheDollarWords.end(), findingAllTheDollarWords.group(2)));
        }
        return replacements;
    }

    private String replaceIdentifiedArgsWithCapture(String escapedMatch, List<Replacement> replacements) {
        String matchTemp = escapedMatch;
        for (int i = replacements.size(); i > 0; --i) {
            String start = matchTemp.substring(0, replacements.get(i - 1).start);
            String end = matchTemp.substring(replacements.get(i - 1).end);
            String whitespaceIfAny = replacements.get(i - 1).whitespaceIfAny;
            matchTemp = start + "(.*)" + whitespaceIfAny + end;
        }
        return matchTemp;
    }

    private String escapeRegexpPunctuation(String matchThis) {
        String escapedMatch = matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
        return escapedMatch;
    }

    private static class Replacement {
        private final int start;
        private final int end;
        private final String whitespaceIfAny;

        public Replacement(int start, int end, String whitespaceIfAny) {
            this.start = start;
            this.end = end;
            this.whitespaceIfAny = whitespaceIfAny;
        }
    }
}

