/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.scenario.Configuration;
import org.jbehave.scenario.PropertyBasedConfiguration;
import org.jbehave.scenario.definition.Blurb;
import org.jbehave.scenario.definition.KeyWords;
import org.jbehave.scenario.definition.ScenarioDefinition;
import org.jbehave.scenario.definition.StoryDefinition;
import org.jbehave.scenario.parser.ScenarioParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternScenarioParser
implements ScenarioParser {
    private final Configuration configuration;

    public PatternScenarioParser() {
        this(new PropertyBasedConfiguration());
    }

    public PatternScenarioParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public StoryDefinition defineStoryFrom(String wholeStoryAsString) {
        Blurb blurb = this.parseBlurbFrom(wholeStoryAsString);
        List<ScenarioDefinition> scenarioDefinitions = this.parseScenariosFrom(wholeStoryAsString);
        return new StoryDefinition(blurb, scenarioDefinitions);
    }

    private List<ScenarioDefinition> parseScenariosFrom(String wholeStoryAsString) {
        ArrayList<ScenarioDefinition> scenarioDefinitions = new ArrayList<ScenarioDefinition>();
        List<String> scenarios = this.splitScenarios(wholeStoryAsString);
        for (String scenario : scenarios) {
            Matcher findingTitle = this.patternToPullScenarioTitlesIntoGroupOne().matcher(scenario);
            scenarioDefinitions.add(new ScenarioDefinition(findingTitle.find() ? findingTitle.group(1).trim() : "", this.findSteps(scenario)));
        }
        return scenarioDefinitions;
    }

    private List<String> findSteps(String scenarioAsString) {
        Matcher matcher = this.patternToPullOutSteps().matcher(scenarioAsString);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(matcher.group(1));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Blurb parseBlurbFrom(String wholeStoryAsString) {
        String scenario = this.configuration.keywords().scenario();
        Pattern findStoryBlurb = Pattern.compile("(.*?)(" + scenario + ").*", 32);
        Matcher matcher = findStoryBlurb.matcher(wholeStoryAsString);
        if (matcher.find()) {
            return new Blurb(matcher.group(1).trim());
        }
        return Blurb.EMPTY;
    }

    protected List<String> splitScenarios(String allScenariosInFile) {
        return this.splitScenariosWithKeyword(allScenariosInFile);
    }

    protected List<String> splitScenariosWithKeyword(String allScenariosInFile) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = "Scenario".replace("Scenario", this.configuration.keywords().scenario());
        String allScenarios = null;
        int keywordIndex = allScenariosInFile.indexOf(scenarioKeyword);
        allScenarios = keywordIndex != -1 ? allScenariosInFile.substring(keywordIndex) : allScenariosInFile;
        for (String scenario : allScenarios.split(scenarioKeyword)) {
            if (scenario.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + scenario);
        }
        return scenarios;
    }

    protected List<String> splitScenariosWithPattern(String allScenariosInFile) {
        Pattern scenarioSplitter = this.patternToPullScenariosIntoGroupFour();
        Matcher matcher = scenarioSplitter.matcher(allScenariosInFile);
        int startAt = 0;
        ArrayList<String> scenarios = new ArrayList<String>();
        try {
            if (matcher.matches()) {
                while (matcher.find(startAt)) {
                    scenarios.add(matcher.group(1));
                    startAt = matcher.start(4);
                }
            } else {
                String loneScenario = allScenariosInFile;
                scenarios.add(loneScenario);
            }
        }
        catch (StackOverflowError e) {
            throw new InvalidPatternException("Failed to parse scenarios (see http://jbehave.org/documentation/known-issues/regex-stack-overflow-errors): " + allScenariosInFile, e);
        }
        return scenarios;
    }

    private Pattern patternToPullScenariosIntoGroupFour() {
        String scenario = this.configuration.keywords().scenario();
        return Pattern.compile(".*?((" + scenario + ") (.|\\s)*?)\\s*(\\Z|" + scenario + ").*", 32);
    }

    private Pattern patternToPullScenarioTitlesIntoGroupOne() {
        KeyWords keywords = this.configuration.keywords();
        String concatenatedKeywords = this.concatenateWithOr(keywords.given(), keywords.when(), keywords.then(), keywords.others());
        String scenario = keywords.scenario();
        return Pattern.compile(scenario + "(.*?)\\s*(" + concatenatedKeywords + ").*");
    }

    private String concatenateWithOr(String given, String when, String then, String[] others) {
        return this.concatenateWithOr(false, given, when, then, others);
    }

    private String concatenateWithSpaceOr(String given, String when, String then, String[] others) {
        return this.concatenateWithOr(true, given, when, then, others);
    }

    private String concatenateWithOr(boolean usingSpace, String given, String when, String then, String[] others) {
        StringBuilder builder = new StringBuilder();
        builder.append(given).append(usingSpace ? "\\s|" : "|");
        builder.append(when).append(usingSpace ? "\\s|" : "|");
        builder.append(then).append(usingSpace ? "\\s|" : "|");
        builder.append(usingSpace ? this.concatenateWithSpaceOr(others) : this.concatenateWithOr(others));
        return builder.toString();
    }

    private String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr(false, new StringBuilder(), keywords);
    }

    private String concatenateWithSpaceOr(String ... keywords) {
        return this.concatenateWithOr(true, new StringBuilder(), keywords);
    }

    private String concatenateWithOr(boolean usingSpace, StringBuilder builder, String[] keywords) {
        for (String other : keywords) {
            builder.append(other).append(usingSpace ? "\\s|" : "|");
        }
        String result = builder.toString();
        return result.substring(0, result.length() - 1);
    }

    private Pattern patternToPullOutSteps() {
        KeyWords keywords = this.configuration.keywords();
        String givenWhenThen = this.concatenateWithOr(keywords.given(), keywords.when(), keywords.then(), keywords.others());
        String givenWhenThenSpaced = this.concatenateWithSpaceOr(keywords.given(), keywords.when(), keywords.then(), keywords.others());
        String scenario = keywords.scenario();
        return Pattern.compile("((" + givenWhenThen + ") (.|\\s)*?)\\s*(\\Z|" + givenWhenThenSpaced + "|" + scenario + ")");
    }

    public static class InvalidPatternException
    extends RuntimeException {
        public InvalidPatternException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

