/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jbehave.scenario.RunnableScenario;
import org.jbehave.scenario.definition.StoryDefinition;
import org.jbehave.scenario.errors.InvalidScenarioResourceException;
import org.jbehave.scenario.errors.ScenarioNotFoundException;
import org.jbehave.scenario.parser.PatternScenarioParser;
import org.jbehave.scenario.parser.ScenarioDefiner;
import org.jbehave.scenario.parser.ScenarioNameResolver;
import org.jbehave.scenario.parser.ScenarioParser;
import org.jbehave.scenario.parser.UnderscoredCamelCaseResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathScenarioDefiner
implements ScenarioDefiner {
    private final ScenarioNameResolver resolver;
    private final ScenarioParser parser;
    private final ClassLoader classLoader;

    public ClasspathScenarioDefiner() {
        this(new UnderscoredCamelCaseResolver(), new PatternScenarioParser(), Thread.currentThread().getContextClassLoader());
    }

    public ClasspathScenarioDefiner(ScenarioParser parser) {
        this(new UnderscoredCamelCaseResolver(), parser, Thread.currentThread().getContextClassLoader());
    }

    public ClasspathScenarioDefiner(ScenarioNameResolver converter, ScenarioParser parser) {
        this(converter, parser, Thread.currentThread().getContextClassLoader());
    }

    public ClasspathScenarioDefiner(ScenarioNameResolver converter, ClassLoader classLoader) {
        this(converter, new PatternScenarioParser(), classLoader);
    }

    public ClasspathScenarioDefiner(ScenarioNameResolver resolver, ScenarioParser parser, ClassLoader classLoader) {
        this.resolver = resolver;
        this.parser = parser;
        this.classLoader = classLoader;
    }

    @Override
    public StoryDefinition loadScenarioDefinitionsFor(Class<? extends RunnableScenario> scenarioClass) {
        String wholeFileAsString = this.asString(this.loadInputStreamFor(scenarioClass));
        return this.parser.defineStoryFrom(wholeFileAsString);
    }

    private InputStream loadInputStreamFor(Class<? extends RunnableScenario> scenarioClass) {
        String scenarioName = this.resolver.resolve(scenarioClass);
        InputStream stream = this.classLoader.getResourceAsStream(scenarioName);
        if (stream == null) {
            throw new ScenarioNotFoundException("Scenario " + scenarioName + " could not be found by classloader " + this.classLoader);
        }
        return stream;
    }

    private String asString(InputStream stream) {
        try {
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            output.write(bytes);
            return output.toString();
        }
        catch (IOException e) {
            throw new InvalidScenarioResourceException("Failed to convert scenario resource to string", e);
        }
    }
}

