/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario.parser;

import org.jbehave.scenario.RunnableScenario;
import org.jbehave.scenario.parser.ScenarioNameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScenarioNameResolver
implements ScenarioNameResolver {
    static final String DOT_REGEX = "\\.";
    static final String SLASH = "/";
    static final String EMPTY = "";
    static final String DEFAULT_EXTENSION = "";
    static final String PATH_PATTERN = "{0}/{1}{2}";
    private final String extension;

    protected AbstractScenarioNameResolver() {
        this("");
    }

    protected AbstractScenarioNameResolver(String extension) {
        this.extension = extension;
    }

    @Override
    public String resolve(Class<? extends RunnableScenario> scenarioClass) {
        String directoryName = this.resolveDirectoryName(scenarioClass);
        String fileName = this.resolveFileName(scenarioClass);
        return this.formatName(directoryName, fileName, this.extension);
    }

    private String formatName(String directoryName, String fileName, String extension) {
        StringBuffer sb = new StringBuffer();
        if (directoryName.length() > 0) {
            sb.append(directoryName).append(SLASH);
        }
        sb.append(fileName);
        if (extension.length() > 0) {
            sb.append(extension);
        }
        return sb.toString();
    }

    protected String resolveDirectoryName(Class<? extends RunnableScenario> scenarioClass) {
        Package scenarioPackage = scenarioClass.getPackage();
        if (scenarioPackage != null) {
            return scenarioPackage.getName().replaceAll(DOT_REGEX, SLASH);
        }
        return "";
    }

    protected abstract String resolveFileName(Class<? extends RunnableScenario> var1);
}

