/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario;

import org.jbehave.scenario.Configuration;
import org.jbehave.scenario.definition.ScenarioDefinition;
import org.jbehave.scenario.definition.StoryDefinition;
import org.jbehave.scenario.errors.ErrorStrategy;
import org.jbehave.scenario.errors.PendingError;
import org.jbehave.scenario.errors.PendingErrorStrategy;
import org.jbehave.scenario.reporters.ScenarioReporter;
import org.jbehave.scenario.steps.CandidateSteps;
import org.jbehave.scenario.steps.Step;
import org.jbehave.scenario.steps.StepResult;

public class ScenarioRunner {
    private State state = new FineSoFar();
    private ErrorStrategy currentStrategy;
    private PendingErrorStrategy pendingStepStrategy;
    private ScenarioReporter reporter;
    private ErrorStrategy errorStrategy;
    private Throwable throwable;

    public void run(StoryDefinition story, Configuration configuration, CandidateSteps ... candidateSteps) throws Throwable {
        this.reporter = configuration.forReportingScenarios();
        this.pendingStepStrategy = configuration.forPendingSteps();
        this.errorStrategy = configuration.forHandlingErrors();
        this.currentStrategy = ErrorStrategy.SILENT;
        this.throwable = null;
        this.reporter.beforeStory(story.getBlurb());
        for (ScenarioDefinition scenario : story.getScenarios()) {
            this.runScenario(configuration, scenario, candidateSteps);
        }
        this.reporter.afterStory();
        this.currentStrategy.handleError(this.throwable);
    }

    private void runScenario(Configuration configuration, ScenarioDefinition scenario, CandidateSteps ... candidateSteps) {
        Step[] steps = configuration.forCreatingSteps().createStepsFrom(scenario, candidateSteps);
        this.reporter.beforeScenario(scenario.getTitle());
        this.state = new FineSoFar();
        for (Step step : steps) {
            this.state.run(step);
        }
        this.reporter.afterScenario();
    }

    private static interface State {
        public void run(Step var1);
    }

    private final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        public void run(Step step) {
            StepResult result = step.perform();
            result.describeTo(ScenarioRunner.this.reporter);
            Throwable thisScenariosThrowable = result.getThrowable();
            if (thisScenariosThrowable != null) {
                ScenarioRunner.this.state = new SomethingHappened();
                ScenarioRunner.this.throwable = this.mostImportantOf(ScenarioRunner.this.throwable, thisScenariosThrowable);
                ScenarioRunner.this.currentStrategy = this.strategyFor(ScenarioRunner.this.throwable);
            }
        }

        private Throwable mostImportantOf(Throwable throwable1, Throwable throwable2) {
            return throwable1 == null ? throwable2 : (throwable1 instanceof PendingError ? (throwable2 == null ? throwable1 : throwable2) : throwable1);
        }

        private ErrorStrategy strategyFor(Throwable throwable) {
            if (throwable instanceof PendingError) {
                return ScenarioRunner.this.pendingStepStrategy;
            }
            return ScenarioRunner.this.errorStrategy;
        }
    }

    private class SomethingHappened
    implements State {
        private SomethingHappened() {
        }

        public void run(Step step) {
            StepResult result = step.doNotPerform();
            result.describeTo(ScenarioRunner.this.reporter);
        }
    }
}

