/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.scenario.RunnableScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioClassLoader
extends URLClassLoader {
    public ScenarioClassLoader(List<String> classpathElements) throws MalformedURLException {
        super(ScenarioClassLoader.classpathURLs(classpathElements), RunnableScenario.class.getClassLoader());
    }

    public ScenarioClassLoader(List<String> classpathElements, ClassLoader parent) throws MalformedURLException {
        super(ScenarioClassLoader.classpathURLs(classpathElements), parent);
    }

    public RunnableScenario newScenario(String scenarioClassName) {
        try {
            RunnableScenario scenario = (RunnableScenario)this.loadClass(scenarioClassName, true).getConstructor(ClassLoader.class).newInstance(this);
            Thread.currentThread().setContextClassLoader(this);
            return scenario;
        }
        catch (ClassCastException e) {
            String message = "The scenario '" + scenarioClassName + "' must be of type '" + RunnableScenario.class.getName() + "'";
            throw new RuntimeException(message, e);
        }
        catch (Exception e) {
            String message = "The scenario '" + scenarioClassName + "' could not be instantiated with class loader: " + this;
            throw new RuntimeException(message, e);
        }
    }

    private List<String> asShortPaths(URL[] urls) {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : urls) {
            String path = url.getPath();
            if (ScenarioClassLoader.isJar(path)) {
                names.add(ScenarioClassLoader.shortPath(path));
                continue;
            }
            names.add(path);
        }
        return names;
    }

    private static String shortPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static boolean isJar(String path) {
        return path.endsWith(".jar");
    }

    private static URL[] classpathURLs(List<String> elements) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (elements != null) {
            for (String element : elements) {
                urls.add(new File(element).toURL());
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public String toString() {
        return "[" + ScenarioClassLoader.class.getName() + " urls=" + this.asShortPaths(this.getURLs()) + "]";
    }
}

