/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario;

import org.jbehave.scenario.Configuration;
import org.jbehave.scenario.MostUsefulConfiguration;
import org.jbehave.scenario.definition.KeyWords;
import org.jbehave.scenario.errors.ErrorStrategy;
import org.jbehave.scenario.errors.PendingErrorStrategy;
import org.jbehave.scenario.parser.ScenarioDefiner;
import org.jbehave.scenario.reporters.PrintStreamScenarioReporter;
import org.jbehave.scenario.reporters.ScenarioReporter;
import org.jbehave.scenario.reporters.StepdocReporter;
import org.jbehave.scenario.steps.StepCreator;
import org.jbehave.scenario.steps.StepdocGenerator;

public class PropertyBasedConfiguration
implements Configuration {
    public static final String FAIL_ON_PENDING = "org.jbehave.failonpending";
    public static final String OUTPUT_ALL = "org.jbehave.outputall";
    private final Configuration defaultConfiguration;

    public PropertyBasedConfiguration() {
        this(new MostUsefulConfiguration());
    }

    public PropertyBasedConfiguration(Configuration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public ScenarioReporter forReportingScenarios() {
        if (System.getProperty(OUTPUT_ALL) == null) {
            return this.defaultConfiguration.forReportingScenarios();
        }
        return new PrintStreamScenarioReporter();
    }

    public ScenarioDefiner forDefiningScenarios() {
        return this.defaultConfiguration.forDefiningScenarios();
    }

    public PendingErrorStrategy forPendingSteps() {
        if (System.getProperty(FAIL_ON_PENDING) == null) {
            return this.defaultConfiguration.forPendingSteps();
        }
        return PendingErrorStrategy.FAILING;
    }

    public StepCreator forCreatingSteps() {
        return this.defaultConfiguration.forCreatingSteps();
    }

    public ErrorStrategy forHandlingErrors() {
        return this.defaultConfiguration.forHandlingErrors();
    }

    public KeyWords keywords() {
        return this.defaultConfiguration.keywords();
    }

    public StepdocGenerator forGeneratingStepdoc() {
        return this.defaultConfiguration.forGeneratingStepdoc();
    }

    public StepdocReporter forReportingStepdoc() {
        return this.defaultConfiguration.forReportingStepdoc();
    }
}

