/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.scenario;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.scenario.Configuration;
import org.jbehave.scenario.PropertyBasedConfiguration;
import org.jbehave.scenario.RunnableScenario;
import org.jbehave.scenario.ScenarioRunner;
import org.jbehave.scenario.definition.StoryDefinition;
import org.jbehave.scenario.reporters.StepdocReporter;
import org.jbehave.scenario.steps.CandidateSteps;
import org.jbehave.scenario.steps.Stepdoc;
import org.jbehave.scenario.steps.StepdocGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScenario
implements RunnableScenario {
    private final Configuration configuration;
    private final ScenarioRunner scenarioRunner;
    private final List<CandidateSteps> candidateSteps = new ArrayList<CandidateSteps>();
    private final Class<? extends RunnableScenario> scenarioClass;

    public AbstractScenario(Class<? extends RunnableScenario> scenarioClass, CandidateSteps ... candidateSteps) {
        this(scenarioClass, new PropertyBasedConfiguration(), candidateSteps);
    }

    public AbstractScenario(Class<? extends RunnableScenario> scenarioClass, Configuration configuration, CandidateSteps ... candidateSteps) {
        this(scenarioClass, new ScenarioRunner(), configuration, candidateSteps);
    }

    public AbstractScenario(Class<? extends RunnableScenario> scenarioClass, ScenarioRunner scenarioRunner, Configuration configuration, CandidateSteps ... candidateSteps) {
        this.scenarioClass = scenarioClass;
        this.configuration = configuration;
        this.scenarioRunner = scenarioRunner;
        this.candidateSteps.addAll(Arrays.asList(candidateSteps));
    }

    @Override
    public void runScenario() throws Throwable {
        StoryDefinition story = this.configuration.forDefiningScenarios().loadScenarioDefinitionsFor(this.scenarioClass);
        CandidateSteps[] steps = new CandidateSteps[this.candidateSteps.size()];
        this.candidateSteps.toArray(steps);
        this.scenarioRunner.run(story, this.configuration, steps);
    }

    @Override
    public void addSteps(CandidateSteps ... steps) {
        this.candidateSteps.addAll(Arrays.asList(steps));
    }

    @Override
    public List<CandidateSteps> getSteps() {
        return this.candidateSteps;
    }

    @Override
    public void generateStepdoc() {
        StepdocGenerator generator = this.configuration.forGeneratingStepdoc();
        List<Stepdoc> stepdocs = generator.generate(this.candidateSteps.toArray(new CandidateSteps[this.candidateSteps.size()]));
        StepdocReporter reporter = this.configuration.forReportingStepdoc();
        reporter.report(stepdocs);
    }
}

