/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.framework.AopProxyUtils;

public interface AuditedMethodExecutionContext {
    public Class<?> getTargetClass();

    public Method getTargetMethod();

    public JoinPoint getJoinPoint();

    public Object[] getTargetMethodArgs();

    default public String getTargetClassName() {
        return this.getTargetClass().getName();
    }

    default public String getTargetMethodName() {
        return this.getTargetMethod().getName();
    }

    default public Parameter[] getTargetMethodParameters() {
        return this.getTargetMethod().getParameters();
    }

    public static AuditedMethodExecutionContext from(JoinPoint jp) {
        if (jp == null) {
            throw new IllegalArgumentException("JoinPoint is null");
        }
        return new JoinPointAuditingExecutionContext(jp);
    }

    public static class JoinPointAuditingExecutionContext
    implements AuditedMethodExecutionContext {
        private final JoinPoint jp;

        private JoinPointAuditingExecutionContext(JoinPoint jp) {
            this.jp = jp;
        }

        @Override
        public Class<?> getTargetClass() {
            return AopProxyUtils.ultimateTargetClass((Object)this.jp.getThis());
        }

        @Override
        public Method getTargetMethod() {
            Signature signature = this.jp.getSignature();
            if (signature instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)signature;
                return ms.getMethod();
            }
            throw new IllegalArgumentException("Unsupported signature type: " + signature.getClass().getName());
        }

        @Override
        public JoinPoint getJoinPoint() {
            return this.jp;
        }

        @Override
        public Object[] getTargetMethodArgs() {
            return this.jp.getArgs();
        }
    }
}

