/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.mongodb;

import com.mongodb.client.ClientSession;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.repository.mongo.JaversMongoTransactionTemplate;
import org.springframework.data.mongodb.ClientSessionExtractor;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringJaversMongoTransactionTemplate
implements JaversMongoTransactionTemplate {
    private final TransactionTemplate springTransactionTemplate;

    public SpringJaversMongoTransactionTemplate(MongoTransactionManager mongoTransactionManager) {
        Validate.argumentsAreNotNull((Object[])new Object[]{mongoTransactionManager});
        this.springTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)mongoTransactionManager);
    }

    public void execute(JaversMongoTransactionTemplate.TransactionCallback callback) {
        this.springTransactionTemplate.execute(status -> {
            ClientSession session = ClientSessionExtractor.getFrom((DefaultTransactionStatus)status);
            callback.doInTransaction(Optional.of(session));
            return null;
        });
    }
}

