/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import org.javers.spring.JaversSpringProperties;
import org.javers.spring.mongodb.DBRefUnproxyObjectAccessHook;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="javers")
public class JaversMongoProperties
extends JaversSpringProperties {
    private static final String DEFAULT_OBJECT_ACCESS_HOOK = DBRefUnproxyObjectAccessHook.class.getName();
    private boolean documentDbCompatibilityEnabled = false;
    private int snapshotsCacheSize = 5000;
    private Mongodb mongodb;
    private Integer asyncCommitExecutorThreadCount = 2;
    private boolean auditableAspectAsyncEnabled = true;

    public boolean isDocumentDbCompatibilityEnabled() {
        return this.documentDbCompatibilityEnabled;
    }

    public void setDocumentDbCompatibilityEnabled(boolean documentDbCompatibilityEnabled) {
        this.documentDbCompatibilityEnabled = documentDbCompatibilityEnabled;
    }

    public int getSnapshotsCacheSize() {
        return this.snapshotsCacheSize;
    }

    public void setSnapshotsCacheSize(int cacheSize) {
        this.snapshotsCacheSize = cacheSize;
    }

    public Mongodb getMongodb() {
        return this.mongodb;
    }

    public void setMongodb(Mongodb mongodb) {
        this.mongodb = mongodb;
    }

    public Integer getAsyncCommitExecutorThreadCount() {
        return this.asyncCommitExecutorThreadCount;
    }

    public void setAsyncCommitExecutorThreadCount(Integer asyncCommitExecutorThreadCount) {
        this.asyncCommitExecutorThreadCount = asyncCommitExecutorThreadCount;
    }

    public boolean isAuditableAspectAsyncEnabled() {
        return this.auditableAspectAsyncEnabled;
    }

    public void setAuditableAspectAsyncEnabled(boolean auditableAspectAsyncEnabled) {
        this.auditableAspectAsyncEnabled = auditableAspectAsyncEnabled;
    }

    public boolean isDedicatedMongodbConfigurationEnabled() {
        return this.mongodb != null;
    }

    protected String defaultObjectAccessHook() {
        return DEFAULT_OBJECT_ACCESS_HOOK;
    }

    public static class Mongodb {
        private String uri;
        private String host;
        private Integer port;
        private String database;
        private String authenticationDatabase;
        private String username;
        private char[] password;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getAuthenticationDatabase() {
            return this.authenticationDatabase;
        }

        public void setAuthenticationDatabase(String authenticationDatabase) {
            this.authenticationDatabase = authenticationDatabase;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public char[] getPassword() {
            return this.password;
        }

        public void setPassword(char[] password) {
            this.password = password;
        }
    }
}

