/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.Optional;
import org.javers.common.validation.Validate;

public class SqlRepositoryConfiguration {
    private final boolean globalIdCacheDisabled;
    private final String schemaName;
    private final boolean schemaManagementEnabled;
    private final String globalIdTableName;
    private final String commitTableName;
    private final String snapshotTableName;
    private final String commitPropertyTableName;

    SqlRepositoryConfiguration(boolean globalIdCacheDisabled, String schemaName, boolean schemaManagementEnabled, String globalIdTableName, String commitTableName, String snapshotTableName, String commitPropertyTableName) {
        Validate.argumentCheck((schemaName == null || !schemaName.isEmpty() ? 1 : 0) != 0, (String)"schemaName should be null or non-empty");
        this.globalIdCacheDisabled = globalIdCacheDisabled;
        this.schemaName = schemaName;
        this.schemaManagementEnabled = schemaManagementEnabled;
        this.globalIdTableName = globalIdTableName;
        this.commitTableName = commitTableName;
        this.snapshotTableName = snapshotTableName;
        this.commitPropertyTableName = commitPropertyTableName;
    }

    public boolean isGlobalIdCacheDisabled() {
        return this.globalIdCacheDisabled;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getSchemaNameAsOptional() {
        return Optional.ofNullable(this.schemaName);
    }

    public boolean isSchemaManagementEnabled() {
        return this.schemaManagementEnabled;
    }

    public Optional<String> getGlobalIdTableName() {
        return Optional.ofNullable(this.globalIdTableName);
    }

    public Optional<String> getCommitTableName() {
        return Optional.ofNullable(this.commitTableName);
    }

    public Optional<String> getSnapshotTableName() {
        return Optional.ofNullable(this.snapshotTableName);
    }

    public Optional<String> getCommitPropertyTableName() {
        return Optional.ofNullable(this.commitPropertyTableName);
    }
}

