/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javers.repository.sql.finders.CommitPropertyDTO;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.SelectBuilder;
import org.javers.repository.sql.session.Session;

public class CommitPropertyFinder {
    private final TableNameProvider tableNameProvider;

    public CommitPropertyFinder(TableNameProvider tableNameProvider) {
        this.tableNameProvider = tableNameProvider;
    }

    List<CommitPropertyDTO> findCommitPropertiesOfSnaphots(Collection<Long> commitPKs, Session session) {
        if (commitPKs.isEmpty()) {
            return Collections.emptyList();
        }
        return ((SelectBuilder)session.select("commit_fk, property_name, property_value").from(this.tableNameProvider.getCommitPropertyTableNameWithSchema()).queryName("commit properties")).and("commit_fk in (" + Joiner.on((String)",").join(commitPKs) + ")", new Parameter[0]).executeQuery(resultSet -> new CommitPropertyDTO(resultSet.getLong("commit_fk"), resultSet.getString("property_name"), resultSet.getString("property_value")));
    }
}

