/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javers.repository.sql.finders.CommitPropertyDTO;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CommitPropertyFinder {
    private final PolyJDBC polyJDBC;
    private final TableNameProvider tableNameProvider;

    public CommitPropertyFinder(PolyJDBC polyJDBC, TableNameProvider tableNameProvider) {
        this.polyJDBC = polyJDBC;
        this.tableNameProvider = tableNameProvider;
    }

    List<CommitPropertyDTO> findCommitPropertiesOfSnaphots(Collection<Long> commitPKs) {
        if (commitPKs.isEmpty()) {
            return Collections.emptyList();
        }
        SelectQuery query = this.polyJDBC.query().select("commit_fk, property_name, property_value").from(this.tableNameProvider.getCommitPropertyTableNameWithSchema()).where("commit_fk in (" + Joiner.on((String)",").join(commitPKs) + ")");
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new ObjectMapper<CommitPropertyDTO>(){

            public CommitPropertyDTO createObject(ResultSet resultSet) throws SQLException {
                return new CommitPropertyDTO(resultSet.getLong("commit_fk"), resultSet.getString("property_name"), resultSet.getString("property_value"));
            }
        });
    }
}

