/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.finders.CdoSnapshotFinder;
import org.javers.repository.sql.repositories.CdoSnapshotRepository;
import org.javers.repository.sql.repositories.CommitMetadataRepository;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.JaversSchemaManager;

public class JaversSqlRepository
implements JaversRepository {
    private final CommitMetadataRepository commitRepository;
    private final GlobalIdRepository globalIdRepository;
    private final CdoSnapshotRepository cdoSnapshotRepository;
    private final CdoSnapshotFinder finder;
    private final JaversSchemaManager schemaManager;

    public JaversSqlRepository(CommitMetadataRepository commitRepository, GlobalIdRepository globalIdRepository, CdoSnapshotRepository cdoSnapshotRepository, CdoSnapshotFinder finder, JaversSchemaManager schemaManager) {
        this.commitRepository = commitRepository;
        this.globalIdRepository = globalIdRepository;
        this.cdoSnapshotRepository = cdoSnapshotRepository;
        this.finder = finder;
        this.schemaManager = schemaManager;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.finder.getLatest(globalId);
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.finder.getSnapshots(queryParams);
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return this.finder.getSnapshots(snapshotIdentifiers);
    }

    public void persist(Commit commit) {
        if (this.commitRepository.isPersisted(commit)) {
            throw new JaversException(JaversExceptionCode.CANT_SAVE_ALREADY_PERSISTED_COMMIT, new Object[]{commit.getId()});
        }
        long commitPk = this.commitRepository.save(commit.getAuthor(), commit.getProperties(), commit.getCommitDate(), commit.getId());
        this.cdoSnapshotRepository.save(commitPk, commit.getSnapshots());
    }

    public CommitId getHeadId() {
        return this.commitRepository.getCommitHeadId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.globalIdRepository.setJsonConverter(jsonConverter);
        this.cdoSnapshotRepository.setJsonConverter(jsonConverter);
        this.finder.setJsonConverter(jsonConverter);
    }

    public void ensureSchema() {
        this.schemaManager.ensureSchema();
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        return this.finder.getStateHistory(globalId, queryParams);
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        return this.finder.getStateHistory(givenClasses, queryParams);
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        return this.finder.getVOStateHistory(ownerEntity, path, queryParams);
    }
}

