/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Pair;
import org.javers.core.commit.CommitId;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.finders.AnySnapshotFilter;
import org.javers.repository.sql.finders.CdoSnapshotMapper;
import org.javers.repository.sql.finders.CdoSnapshotsEnricher;
import org.javers.repository.sql.finders.CommitPropertyDTO;
import org.javers.repository.sql.finders.CommitPropertyFinder;
import org.javers.repository.sql.finders.GlobalIdFilter;
import org.javers.repository.sql.finders.ManagedClassFilter;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.finders.SnapshotIdFilter;
import org.javers.repository.sql.finders.SnapshotIdentifiersFilter;
import org.javers.repository.sql.finders.VoOwnerEntityFilter;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private final GlobalIdRepository globalIdRepository;
    private final CommitPropertyFinder commitPropertyFinder;
    private final CdoSnapshotMapper cdoSnapshotMapper;
    private final CdoSnapshotsEnricher cdoSnapshotsEnricher = new CdoSnapshotsEnricher();
    private JsonConverter jsonConverter;

    public CdoSnapshotFinder(PolyJDBC polyJDBC, GlobalIdRepository globalIdRepository, CommitPropertyFinder commitPropertyFinder) {
        this.polyJDBC = polyJDBC;
        this.globalIdRepository = globalIdRepository;
        this.commitPropertyFinder = commitPropertyFinder;
        this.cdoSnapshotMapper = new CdoSnapshotMapper();
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Optional.empty();
        }
        Optional<Long> maxSnapshot = this.selectMaxSnapshotPrimaryKey((Long)globalIdPk.get());
        if (maxSnapshot.isEmpty()) {
            return Optional.empty();
        }
        QueryParams oneItemLimit = QueryParamsBuilder.withLimit((int)1).build();
        return Optional.of((Object)this.fetchCdoSnapshots(new SnapshotIdFilter((Long)maxSnapshot.get()), (Optional<QueryParams>)Optional.of((Object)oneItemLimit)).get(0));
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.fetchCdoSnapshots(new AnySnapshotFilter(), (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return this.fetchCdoSnapshots(new SnapshotIdentifiersFilter(this.globalIdRepository, snapshotIdentifiers), (Optional<QueryParams>)Optional.empty());
    }

    public List<CdoSnapshot> getStateHistory(ManagedType managedType, Optional<String> propertyName, QueryParams queryParams) {
        ManagedClassFilter classFilter = new ManagedClassFilter(managedType.getName(), propertyName);
        return this.fetchCdoSnapshots(classFilter, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getVOStateHistory(EntityType ownerEntity, String fragment, QueryParams queryParams) {
        VoOwnerEntityFilter voOwnerFilter = new VoOwnerEntityFilter(ownerEntity.getName(), fragment);
        return this.fetchCdoSnapshots(voOwnerFilter, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, Optional<String> propertyName, QueryParams queryParams) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Collections.emptyList();
        }
        return this.fetchCdoSnapshots(new GlobalIdFilter((Long)globalIdPk.get(), propertyName), (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    private List<CdoSnapshot> fetchCdoSnapshots(SnapshotFilter snapshotFilter, Optional<QueryParams> queryParams) {
        List<Pair<CdoSnapshotSerialized, Long>> serializedSnapshots = this.queryForCdoSnapshotDTOs(snapshotFilter, queryParams);
        List<CommitPropertyDTO> commitPropertyDTOs = this.commitPropertyFinder.findCommitPropertiesOfSnaphots(Pair.collectRightAsSet(serializedSnapshots));
        this.cdoSnapshotsEnricher.enrichWithCommitProperties(serializedSnapshots, commitPropertyDTOs);
        ArrayList<CdoSnapshot> result = new ArrayList<CdoSnapshot>();
        for (Pair<CdoSnapshotSerialized, Long> serializedSnapshot : serializedSnapshots) {
            result.add(this.jsonConverter.fromSerializedSnapshot((CdoSnapshotSerialized)serializedSnapshot.left()));
        }
        return result;
    }

    private List<Pair<CdoSnapshotSerialized, Long>> queryForCdoSnapshotDTOs(SnapshotFilter snapshotFilter, Optional<QueryParams> queryParams) {
        SelectQuery query = this.polyJDBC.query().select(snapshotFilter.select());
        snapshotFilter.addFrom(query);
        snapshotFilter.addWhere(query);
        if (queryParams.isPresent()) {
            this.applyQueryParams(snapshotFilter, (QueryParams)queryParams.get(), query);
        }
        query.orderBy("snapshot_pk", Order.DESC);
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)this.cdoSnapshotMapper);
    }

    private void applyQueryParams(SnapshotFilter snapshotFilter, QueryParams queryParams, SelectQuery query) {
        if (queryParams.from().isPresent()) {
            snapshotFilter.addFromDateCondition(query, (LocalDateTime)queryParams.from().get());
        }
        if (queryParams.to().isPresent()) {
            snapshotFilter.addToDateCondition(query, (LocalDateTime)queryParams.to().get());
        }
        if (queryParams.commitId().isPresent()) {
            snapshotFilter.addCommitIdCondition(query, (CommitId)queryParams.commitId().get());
        }
        if (queryParams.version().isPresent()) {
            snapshotFilter.addVersionCondition(query, (Long)queryParams.version().get());
        }
        if (queryParams.author().isPresent()) {
            snapshotFilter.addAuthorCondition(query, (String)queryParams.author().get());
        }
        this.addCommitPropertyConditions(snapshotFilter, query, queryParams.commitProperties());
        query.limit(queryParams.limit(), queryParams.skip());
    }

    private void addCommitPropertyConditions(SnapshotFilter snapshotFilter, SelectQuery query, Map<String, String> commitProperties) {
        for (Map.Entry<String, String> commitProperty : commitProperties.entrySet()) {
            snapshotFilter.addCommitPropertyCondition(query, commitProperty.getKey(), commitProperty.getValue());
        }
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(long globalIdPk) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalIdPk);
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

