/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.polyjdbc.core.query.mapper.ObjectMapper;

class CdoSnapshotObjectMapper
implements ObjectMapper<CdoSnapshot> {
    private final Optional<GlobalId> providedGlobalId;
    private final JsonConverter jsonConverter;
    private static final String GLOBAL_CDO_ID = "globalId";
    private static final String COMMIT_METADATA = "commitMetadata";
    private static final String STATE_NAME = "state";
    private static final String TYPE_NAME = "type";
    private static final String CHANGED_NAME = "changedProperties";
    private static final String VERSION = "version";

    public CdoSnapshotObjectMapper(JsonConverter jsonConverter, Optional<GlobalId> providedGlobalId) {
        this.jsonConverter = jsonConverter;
        this.providedGlobalId = providedGlobalId;
    }

    public CdoSnapshot createObject(ResultSet resultSet) throws SQLException {
        JsonObject json = new JsonObject();
        json.add(COMMIT_METADATA, this.assembleCommitMetadata(resultSet));
        json.add(STATE_NAME, this.jsonConverter.fromJsonToJsonElement(resultSet.getString(STATE_NAME)));
        json.add(CHANGED_NAME, this.assembleChangedPropNames(resultSet));
        json.addProperty(TYPE_NAME, resultSet.getString(TYPE_NAME));
        json.addProperty(VERSION, (Number)resultSet.getLong(VERSION));
        if (this.providedGlobalId.isPresent()) {
            json.add(GLOBAL_CDO_ID, this.jsonConverter.toJsonElement(this.providedGlobalId.get()));
        } else {
            json.add(GLOBAL_CDO_ID, this.assembleGlobalId(resultSet));
        }
        return (CdoSnapshot)this.jsonConverter.fromJson((JsonElement)json, CdoSnapshot.class);
    }

    private JsonElement assembleChangedPropNames(ResultSet resultSet) throws SQLException {
        JsonObject jsonObject = new JsonObject();
        String propNamesJSON = resultSet.getString("changed_properties");
        if (propNamesJSON == null || propNamesJSON.isEmpty()) {
            return jsonObject;
        }
        return this.jsonConverter.fromJsonToJsonElement(propNamesJSON);
    }

    private JsonElement assembleCommitMetadata(ResultSet resultSet) throws SQLException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("author", resultSet.getString("author"));
        jsonObject.add("commitDate", this.jsonConverter.toJsonElement((Object)resultSet.getTimestamp("commit_date")));
        jsonObject.addProperty("id", (Number)resultSet.getBigDecimal("commit_id"));
        return jsonObject;
    }

    private JsonElement assembleGlobalId(ResultSet resultSet) {
        try {
            String fragment = resultSet.getString("fragment");
            String localIdJSON = resultSet.getString("local_id");
            String cdoType = resultSet.getString("qualified_name");
            JsonObject json = this.assembleOneGlobalId(cdoType, localIdJSON, fragment);
            if (resultSet.getLong("owner_id_fk") > 0L) {
                String ownerFragment = resultSet.getString("owner_fragment");
                String ownerLocalIdJSON = resultSet.getString("owner_local_id");
                String ownerCdoType = resultSet.getString("owner_qualified_name");
                JsonObject ownerId = this.assembleOneGlobalId(ownerCdoType, ownerLocalIdJSON, ownerFragment);
                json.add("ownerId", (JsonElement)ownerId);
            }
            return json;
        }
        catch (SQLException e) {
            throw new JaversException(JaversExceptionCode.SQL_EXCEPTION, new Object[]{e.getMessage()});
        }
    }

    private JsonObject assembleOneGlobalId(String typeName, String localIdJson, String fragment) throws SQLException {
        JsonObject json = new JsonObject();
        if (localIdJson != null) {
            json.addProperty("entity", typeName);
            json.add("cdoId", this.jsonConverter.fromJsonToJsonElement(localIdJson));
        } else {
            json.addProperty("valueObject", typeName);
            json.addProperty("fragment", fragment);
        }
        return json;
    }
}

