/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.util.Map;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private SchemaInspector schemaInspector;
    private SchemaManager schemaManager;
    private Dialect dialect;
    private final FixedSchemaFactory schemaFactory;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory fixedSchemaFactory, PolyJDBC polyJDBC) {
        this.dialect = dialect;
        this.schemaFactory = fixedSchemaFactory;
        this.schemaInspector = polyJDBC.schemaInspector();
        this.schemaManager = polyJDBC.schemaManager();
    }

    public void ensureSchema() {
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
    }

    private void ensureTable(String tableName, Schema schema) {
        block3: {
            try {
                if (!this.schemaInspector.relationExists(tableName)) break block3;
            }
            catch (Throwable throwable) {
                TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
                throw throwable;
            }
            TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        this.schemaManager.create(schema);
        TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }
}

