/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.string.RegexEscape;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.date.DateTypeCoreAdapters;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.mongo.MongoSchemaManager;
import org.javers.repository.mongo.model.MongoHeadId;
import org.joda.time.LocalDateTime;

public class MongoRepository
implements JaversRepository {
    private static final int DESC = -1;
    private final MongoSchemaManager mongoSchemaManager;
    private JsonConverter jsonConverter;

    public MongoRepository(MongoDatabase mongo) {
        this(mongo, null);
    }

    MongoRepository(MongoDatabase mongo, JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
        this.mongoSchemaManager = new MongoSchemaManager(mongo);
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    void clean() {
        this.snapshotsCollection().deleteMany((Bson)new Document());
        this.headCollection().deleteMany((Bson)new Document());
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Bson query = queryParams.isAggregate() ? this.createIdQueryWithAggregate(globalId) : this.createIdQuery(globalId);
        return this.queryForSnapshots(query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.getLatest(this.createIdQuery(globalId));
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.queryForSnapshots((Bson)new BasicDBObject(), (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return snapshotIdentifiers.isEmpty() ? Collections.emptyList() : this.queryForSnapshots(this.createSnapshotIdentifiersQuery(snapshotIdentifiers), (Optional<QueryParams>)Optional.empty());
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        BasicDBObject query = new BasicDBObject("globalId.ownerId.entity", (Object)ownerEntity.getName());
        query.append("globalId.fragment", (Object)path);
        return this.queryForSnapshots((Bson)query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getStateHistory(ManagedType givenClass, QueryParams queryParams) {
        Bson query = this.createManagedTypeQuery(givenClass, queryParams.isAggregate());
        return this.queryForSnapshots(query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public CommitId getHeadId() {
        Document headId = (Document)this.headCollection().find().first();
        if (headId == null) {
            return null;
        }
        return new MongoHeadId(headId).toCommitId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void ensureSchema() {
        this.mongoSchemaManager.ensureSchema();
    }

    private Bson createIdQuery(GlobalId id) {
        return new BasicDBObject("globalId_key", (Object)id.value());
    }

    private Bson createIdQueryWithAggregate(GlobalId id) {
        return Filters.or((Bson[])new Bson[]{this.createIdQuery(id), MongoRepository.prefixQuery("globalId_key", id.value() + "#")});
    }

    private Bson createVersionQuery(Long version) {
        return new BasicDBObject("version", (Object)version);
    }

    private Bson createSnapshotIdentifiersQuery(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        List descFilters = Lists.transform(new ArrayList<SnapshotIdentifier>(snapshotIdentifiers), (Function)new Function<SnapshotIdentifier, Bson>(){

            public Bson apply(SnapshotIdentifier snapshotIdentifier) {
                return Filters.and((Bson[])new Bson[]{MongoRepository.this.createIdQuery(snapshotIdentifier.getGlobalId()), MongoRepository.this.createVersionQuery(snapshotIdentifier.getVersion())});
            }
        });
        return Filters.or((Iterable)descFilters);
    }

    private Bson createManagedTypeQuery(ManagedType managedType, boolean aggregate) {
        if (managedType instanceof ValueObjectType) {
            return new BasicDBObject("globalId.valueObject", (Object)managedType.getName());
        }
        Bson query = MongoRepository.prefixQuery("globalId_key", managedType.getName() + "/");
        if (!aggregate) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.exists((String)"globalId.entity")});
        }
        return query;
    }

    private CdoSnapshot readFromDBObject(Document dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(dbObject.toJson(), CdoSnapshot.class);
    }

    private Document writeToDBObject(CdoSnapshot snapshot) {
        Validate.conditionFulfilled((this.jsonConverter != null ? 1 : 0) != 0, (String)"MongoRepository: jsonConverter is null");
        Document dbObject = Document.parse((String)this.jsonConverter.toJson((Object)snapshot));
        dbObject.append("globalId_key", (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private MongoCollection<Document> snapshotsCollection() {
        return this.mongoSchemaManager.snapshotsCollection();
    }

    private MongoCollection<Document> headCollection() {
        return this.mongoSchemaManager.headCollection();
    }

    private void persistSnapshots(Commit commit) {
        MongoCollection<Document> collection = this.snapshotsCollection();
        for (CdoSnapshot snapshot : commit.getSnapshots()) {
            collection.insertOne((Object)this.writeToDBObject(snapshot));
        }
    }

    private void persistHeadId(Commit commit) {
        MongoCollection<Document> headIdCollection = this.headCollection();
        Document oldHead = (Document)headIdCollection.find().first();
        MongoHeadId newHeadId = new MongoHeadId(commit.getId());
        if (oldHead == null) {
            headIdCollection.insertOne((Object)newHeadId.toDocument());
        } else {
            headIdCollection.updateOne(this.objectIdFiler(oldHead), (Bson)newHeadId.getUpdateCommand());
        }
    }

    private Bson objectIdFiler(Document document) {
        return Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id"));
    }

    private MongoCursor<Document> getMongoSnapshotsCursor(Bson query, Optional<QueryParams> queryParams) {
        FindIterable findIterable = this.snapshotsCollection().find(this.applyQueryParams(query, queryParams)).sort((Bson)new Document("commitMetadata.id", (Object)-1));
        return this.applyQueryParams((FindIterable<Document>)findIterable, queryParams).iterator();
    }

    private Bson applyQueryParams(Bson query, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = (QueryParams)queryParams.get();
            if (params.from().isPresent()) {
                query = this.addFromDateFiler(query, (LocalDateTime)params.from().get());
            }
            if (params.to().isPresent()) {
                query = this.addToDateFilter(query, (LocalDateTime)params.to().get());
            }
            if (params.commitId().isPresent()) {
                query = this.addCommitIdFilter(query, (CommitId)params.commitId().get());
            }
            if (params.version().isPresent()) {
                query = this.addVersionFilter(query, (Long)params.version().get());
            }
            if (params.author().isPresent()) {
                query = this.addAuthorFilter(query, (String)params.author().get());
            }
            if (!params.commitProperties().isEmpty()) {
                query = this.addCommitPropertiesFilter(query, params.commitProperties());
            }
            if (params.changedProperty().isPresent()) {
                query = this.addChangedPropertyFilter(query, (String)params.changedProperty().get());
            }
        }
        return query;
    }

    private FindIterable<Document> applyQueryParams(FindIterable<Document> findIterable, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = (QueryParams)queryParams.get();
            findIterable = findIterable.limit(params.limit()).skip(params.skip());
        }
        return findIterable;
    }

    private Bson addFromDateFiler(Bson query, LocalDateTime from) {
        return Filters.and((Bson[])new Bson[]{query, Filters.gte((String)"commitMetadata.commitDate", (Object)DateTypeCoreAdapters.serialize((LocalDateTime)from))});
    }

    private Bson addToDateFilter(Bson query, LocalDateTime to) {
        return Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.commitDate", (Object)DateTypeCoreAdapters.serialize((LocalDateTime)to))});
    }

    private Bson addCommitIdFilter(Bson query, CommitId commitId) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject("commitMetadata.id", (Object)commitId.valueAsNumber().doubleValue())});
    }

    private Bson addChangedPropertyFilter(Bson query, String changedProperty) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject("changedProperties", (Object)changedProperty)});
    }

    private Bson addVersionFilter(Bson query, Long version) {
        return Filters.and((Bson[])new Bson[]{query, this.createVersionQuery(version)});
    }

    private Bson addCommitPropertiesFilter(Bson query, Map<String, String> commitProperties) {
        ArrayList<BasicDBObject> propertyFilters = new ArrayList<BasicDBObject>();
        for (Map.Entry<String, String> commitProperty : commitProperties.entrySet()) {
            BasicDBObject propertyFilter = new BasicDBObject("commitMetadata.properties", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("key", (Object)commitProperty.getKey()).append("value", (Object)commitProperty.getValue())));
            propertyFilters.add(propertyFilter);
        }
        return Filters.and((Bson[])new Bson[]{query, Filters.and((Bson[])propertyFilters.toArray(new Bson[0]))});
    }

    private Bson addAuthorFilter(Bson query, String author) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject("commitMetadata.author", (Object)author)});
    }

    private Optional<CdoSnapshot> getLatest(Bson idQuery) {
        QueryParams queryParams = QueryParamsBuilder.withLimit((int)1).build();
        MongoCursor<Document> mongoLatest = this.getMongoSnapshotsCursor(idQuery, (Optional<QueryParams>)Optional.of((Object)queryParams));
        if (!mongoLatest.hasNext()) {
            return Optional.empty();
        }
        Document dbObject = MongoRepository.getOne(mongoLatest);
        return Optional.of((Object)this.readFromDBObject(dbObject));
    }

    private List<CdoSnapshot> queryForSnapshots(Bson query, Optional<QueryParams> queryParams) {
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        try (MongoCursor<Document> mongoSnapshots = this.getMongoSnapshotsCursor(query, queryParams);){
            while (mongoSnapshots.hasNext()) {
                Document dbObject = (Document)mongoSnapshots.next();
                snapshots.add(this.readFromDBObject(dbObject));
            }
            ArrayList<CdoSnapshot> arrayList = snapshots;
            return arrayList;
        }
    }

    private static <T> T getOne(MongoCursor<T> mongoCursor) {
        try {
            Object object = mongoCursor.next();
            return (T)object;
        }
        finally {
            mongoCursor.close();
        }
    }

    private static Bson prefixQuery(String fieldName, String prefix) {
        return Filters.regex((String)fieldName, (String)("^" + RegexEscape.escape((String)prefix) + ".*"));
    }
}

