/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.model.MongoHeadId;

public class MongoRepository
implements JaversRepository {
    private static final int DESC = -1;
    private static final int ASC = 1;
    public static final String SNAPSHOTS = "jv_snapshots";
    public static final String COMMIT_ID = "commitMetadata.id";
    public static final String GLOBAL_ID_KEY = "globalId_key";
    private DB mongo;
    private JsonConverter jsonConverter;

    public MongoRepository(DB mongo) {
        this.mongo = mongo;
        DBCollection snapshots = this.snapshotsCollection();
        snapshots.ensureIndex((DBObject)new BasicDBObject(GLOBAL_ID_KEY, (Object)1), "global_id_idx");
        this.headCollection();
    }

    public MongoRepository(DB mongo, JsonConverter jsonConverter) {
        this.mongo = mongo;
        this.jsonConverter = jsonConverter;
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    private void persistSnapshots(Commit commit) {
        DBCollection collection = this.snapshotsCollection();
        for (CdoSnapshot snapshot : commit.getSnapshots()) {
            collection.save(this.writeToDBObject(snapshot));
        }
    }

    private void persistHeadId(Commit commit) {
        DBCollection headIdCollection = this.headCollection();
        DBObject oldHeadId = headIdCollection.findOne();
        MongoHeadId newHeadId = new MongoHeadId(this.jsonConverter.toJson((Object)commit.getId()));
        if (oldHeadId == null) {
            headIdCollection.save((DBObject)newHeadId);
        } else {
            headIdCollection.findAndModify(oldHeadId, (DBObject)newHeadId);
        }
    }

    void clean() {
        this.snapshotsCollection().remove((DBObject)new BasicDBObject());
        this.headCollection().remove((DBObject)new BasicDBObject());
    }

    public List<CdoSnapshot> getStateHistory(GlobalCdoId globalId, int limit) {
        return this.getStateHistory((DBObject)this.createIdQuery(globalId), limit);
    }

    public List<CdoSnapshot> getStateHistory(GlobalIdDTO globalIdDTO, int limit) {
        return this.getStateHistory((DBObject)this.createIdQuery(globalIdDTO), limit);
    }

    private List<CdoSnapshot> getStateHistory(DBObject cdoId, int limit) {
        DBCursor mongoSnapshots = this.getMongoSnapshotsCoursor(cdoId, limit);
        Iterator iterator = mongoSnapshots.iterator();
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        while (iterator.hasNext()) {
            DBObject dbObject = (DBObject)iterator.next();
            snapshots.add(this.readFromDBObject(dbObject));
        }
        return snapshots;
    }

    private DBCursor getMongoSnapshotsCoursor(DBObject idQuery, int limit) {
        return this.snapshotsCollection().find(idQuery).sort((DBObject)new BasicDBObject(COMMIT_ID, (Object)-1)).limit(limit);
    }

    public Optional<CdoSnapshot> getLatest(GlobalCdoId globalId) {
        return this.getLatest((DBObject)this.createIdQuery(globalId));
    }

    public Optional<CdoSnapshot> getLatest(GlobalIdDTO globalIdDTO) {
        return this.getLatest((DBObject)this.createIdQuery(globalIdDTO));
    }

    private Optional<CdoSnapshot> getLatest(DBObject idQuery) {
        DBCursor mongoLatest = this.getMongoSnapshotsCoursor(idQuery, 1);
        if (mongoLatest.size() == 0) {
            return Optional.empty();
        }
        DBObject dbObject = (DBObject)mongoLatest.iterator().next();
        return Optional.of((Object)this.readFromDBObject(dbObject));
    }

    public CommitId getHeadId() {
        DBObject headId = this.headCollection().findOne();
        if (headId == null) {
            return null;
        }
        return (CommitId)this.jsonConverter.fromJson(headId.get("id").toString(), CommitId.class);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private BasicDBObject createIdQuery(GlobalCdoId id) {
        return new BasicDBObject(GLOBAL_ID_KEY, (Object)id.value());
    }

    private BasicDBObject createIdQuery(GlobalIdDTO id) {
        return new BasicDBObject(GLOBAL_ID_KEY, (Object)id.value());
    }

    private CdoSnapshot readFromDBObject(DBObject dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(dbObject.toString(), CdoSnapshot.class);
    }

    private DBObject writeToDBObject(CdoSnapshot snapshot) {
        BasicDBObject dbObject = (BasicDBObject)JSON.parse((String)this.jsonConverter.toJson((Object)snapshot));
        dbObject.append(GLOBAL_ID_KEY, (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private DBCollection snapshotsCollection() {
        return this.mongo.getCollection(SNAPSHOTS);
    }

    private DBCollection headCollection() {
        return this.mongo.getCollection("jv_head_id");
    }
}

