/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jdbc;

import javax.sql.DataSource;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractConfiguration;
import org.javers.repository.jdbc.DataSourceFactory;
import org.javers.repository.jdbc.DialectName;
import org.polyjdbc.core.dialect.Dialect;

public class JdbcRepositoryConfiguration
extends AbstractConfiguration {
    public static final String DIALECT_PROPERTY = "jdbc.dialect";
    public static final String URL_PROPERTY = "jdbc.database.url";
    public static final String USERNAME_PROPERTY = "jdbc.database.username";
    public static final String PASSWORD_PROPERTY = "jdbc.database.password";
    private DialectName dialectName;
    private String databaseUrl;
    private String username;
    private String password;

    public JdbcRepositoryConfiguration() {
        this.readProperties("jdbc-default.properties");
    }

    public void withDialect(DialectName dialect) {
        Validate.argumentIsNotNull((Object)((Object)dialect));
        this.dialectName = dialect;
    }

    public void withDatabaseUrl(String databaseUrl) {
        Validate.argumentIsNotNull((Object)databaseUrl);
        this.databaseUrl = databaseUrl;
    }

    public void withUsername(String username) {
        this.username = username;
    }

    public void withPassword(String password) {
        this.password = password;
    }

    public DialectName getDialectName() {
        return this.dialectName;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Dialect getPollyDialect() {
        return this.dialectName.getPolyDialect();
    }

    protected DataSource createConnectionPool() {
        return DataSourceFactory.createDBCP(this.getDialectName().getDriverClass(), this.getDatabaseUrl(), this.getUsername(), this.getPassword());
    }

    public void assemble() {
        if (this.containsPropertyKey(DIALECT_PROPERTY)) {
            this.dialectName = (DialectName)this.getEnumProperty(DIALECT_PROPERTY, DialectName.class);
        }
        if (this.containsPropertyKey(URL_PROPERTY)) {
            this.databaseUrl = this.getStringProperty(URL_PROPERTY);
        }
        if (this.containsPropertyKey(USERNAME_PROPERTY)) {
            this.username = this.getStringProperty(USERNAME_PROPERTY);
        }
        if (this.containsPropertyKey(PASSWORD_PROPERTY)) {
            this.password = this.getStringProperty(PASSWORD_PROPERTY);
        }
    }
}

