/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Diff;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.SnapshotType;

public final class Commit {
    private final CommitMetadata commitMetadata;
    private final List<CdoSnapshot> snapshots;
    private final Diff diff;

    Commit(CommitMetadata commitMetadata, List<CdoSnapshot> snapshots, Diff diff) {
        Validate.argumentsAreNotNull(commitMetadata, snapshots, diff);
        this.commitMetadata = commitMetadata;
        this.snapshots = snapshots;
        this.diff = diff;
    }

    public CommitId getId() {
        return this.commitMetadata.getId();
    }

    public String getAuthor() {
        return this.commitMetadata.getAuthor();
    }

    public Map<String, String> getProperties() {
        return this.commitMetadata.getProperties();
    }

    Diff getDiff() {
        return this.diff;
    }

    public LocalDateTime getCommitDate() {
        return this.commitMetadata.getCommitDate();
    }

    public Instant getCommitDateInstant() {
        return this.commitMetadata.getCommitDateInstant();
    }

    public List<CdoSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    public Changes getChanges() {
        return this.diff.getChanges();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Commit(id:" + String.valueOf(this.commitMetadata.getId()));
        b.append(", " + this.snapshotSummary());
        b.append(", author:" + this.commitMetadata.getAuthor());
        b.append(")");
        return b.toString();
    }

    private String snapshotSummary() {
        StringBuilder b = new StringBuilder();
        b.append("snapshots:" + this.snapshots.size() + " ");
        for (Map.Entry<SnapshotType, Integer> e : this.countByType().entrySet()) {
            b.append(String.valueOf((Object)e.getKey()) + ":" + String.valueOf(e.getValue()) + " ");
        }
        return b.toString().trim();
    }

    private Map<SnapshotType, Integer> countByType() {
        HashMap<SnapshotType, Integer> result = new HashMap<SnapshotType, Integer>();
        for (CdoSnapshot snapshot : this.snapshots) {
            SnapshotType key = snapshot.getType();
            if (result.containsKey((Object)key)) {
                result.put(key, (Integer)result.get((Object)key) + 1);
                continue;
            }
            result.put(key, 1);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit other = (Commit)o;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

