/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.Cdo;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ManagedType;

public final class CdoSnapshot
extends Cdo {
    private CommitMetadata commitMetadata;
    private final CdoSnapshotState state;
    private final SnapshotType type;
    private final List<String> changed;
    private final long version;
    private final GlobalId globalId;

    CdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata, CdoSnapshotState state, SnapshotType type, List<String> changed, ManagedType managedType, long version) {
        super(managedType);
        Validate.argumentsAreNotNull(new Object[]{state, commitMetadata, type, managedType, globalId});
        this.state = state;
        this.commitMetadata = commitMetadata;
        this.type = type;
        this.changed = changed;
        this.version = version;
        this.globalId = globalId;
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.empty();
    }

    @Override
    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public int size() {
        return this.state.size();
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.state.getPropertyValue(propertyName);
    }

    @Override
    public Object getPropertyValue(Property property) {
        return this.state.getPropertyValue(property);
    }

    public List<String> getChanged() {
        return Collections.unmodifiableList(this.changed);
    }

    public boolean hasChangeAt(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return this.changed.contains(propertyName);
    }

    public boolean isFirstVersion() {
        return this.version == 1L;
    }

    @Override
    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return this.state.isNull(property.getName());
    }

    public CommitId getCommitId() {
        return this.commitMetadata.getId();
    }

    public CommitMetadata getCommitMetadata() {
        return this.commitMetadata;
    }

    public boolean stateEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdoSnapshot other = (CdoSnapshot)o;
        return this.state.equals(other.state);
    }

    public CdoSnapshotState getState() {
        return this.state;
    }

    <R> List<R> mapProperties(BiFunction<String, Object, R> mapper) {
        return this.getState().mapProperties(mapper);
    }

    void forEachProperty(BiConsumer<String, Object> consumer) {
        this.getState().forEachProperty(consumer);
    }

    public boolean isInitial() {
        return this.type == SnapshotType.INITIAL;
    }

    public boolean isInstance() {
        return this.globalId instanceof InstanceId;
    }

    public boolean isTerminal() {
        return this.type == SnapshotType.TERMINAL;
    }

    public boolean isUpdate() {
        return this.type == SnapshotType.UPDATE;
    }

    public SnapshotType getType() {
        return this.type;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Snapshot{commit:").append(this.getCommitMetadata().getId()).append(", ").append("id:").append(this.getGlobalId()).append(", ").append("version:").append(this.getVersion()).append(", ").append("state:" + String.valueOf(this.getState()) + "}");
        return stringBuilder.toString();
    }

    public CdoSnapshotState stateWithAllPrimitives() {
        CdoSnapshotStateBuilder builder = CdoSnapshotStateBuilder.cdoSnapshotState();
        this.getManagedType().getProperties().forEach(p -> builder.withPropertyValue((Property)p, this.getPropertyValue((Property)p)));
        return builder.build();
    }
}

