/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.CollectionWrapper;
import org.javers.core.graph.CollectionsCdoFactory;
import org.javers.core.graph.CollectionsGraphBuilder;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectGraph;
import org.javers.core.graph.ObjectGraphBuilder;
import org.javers.core.metamodel.type.TypeMapper;

public class LiveGraphFactory {
    private final TypeMapper typeMapper;
    private final LiveCdoFactory liveCdoFactory;
    private final CollectionsCdoFactory collectionsCdoFactory;

    LiveGraphFactory(TypeMapper typeMapper, LiveCdoFactory liveCdoFactory, CollectionsCdoFactory collectionsCdoFactory) {
        this.typeMapper = typeMapper;
        this.liveCdoFactory = liveCdoFactory;
        this.collectionsCdoFactory = collectionsCdoFactory;
    }

    public ObjectGraph createLiveGraph(Collection handle, Class clazz) {
        CollectionWrapper wrappedCollection = (CollectionWrapper)this.wrapTopLevelContainer(handle);
        return new CollectionsGraphBuilder(new ObjectGraphBuilder(this.typeMapper, this.liveCdoFactory), this.collectionsCdoFactory).buildGraph(wrappedCollection, clazz);
    }

    public LiveGraph createLiveGraph(Object handle) {
        Object wrappedHandle = this.wrapTopLevelContainer(handle);
        return new ObjectGraphBuilder(this.typeMapper, this.liveCdoFactory).buildGraph(wrappedHandle);
    }

    public Cdo createCdo(Object cdo) {
        return this.liveCdoFactory.create(cdo, null);
    }

    private Object wrapTopLevelContainer(Object handle) {
        if (handle instanceof Map) {
            return new MapWrapper((Map)handle);
        }
        if (handle instanceof List) {
            return new ListWrapper((List)handle);
        }
        if (handle instanceof Set) {
            return new SetWrapper((Set)handle);
        }
        if (handle.getClass().isArray()) {
            return new ArrayWrapper(LiveGraphFactory.convertToObjectArray(handle));
        }
        return handle;
    }

    public static Class getMapWrapperType() {
        return MapWrapper.class;
    }

    public static Class getSetWrapperType() {
        return SetWrapper.class;
    }

    public static Class getListWrapperType() {
        return ListWrapper.class;
    }

    public static Class getArrayWrapperType() {
        return ArrayWrapper.class;
    }

    private static Object[] convertToObjectArray(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        int arrayLength = Array.getLength(obj);
        Object[] retArray = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            retArray[i] = Array.get(obj, i);
        }
        return retArray;
    }

    static class MapWrapper {
        private final Map<Object, Object> map;

        MapWrapper(Map map) {
            this.map = map;
        }
    }

    static class ListWrapper
    implements CollectionWrapper {
        private final List<Object> list;

        ListWrapper(List list) {
            this.list = list;
        }

        List<Object> getList() {
            return this.list;
        }
    }

    static class SetWrapper
    implements CollectionWrapper {
        private final Set<Object> set;

        SetWrapper(Set set) {
            this.set = set;
        }

        Set<Object> getSet() {
            return this.set;
        }
    }

    static class ArrayWrapper {
        private final Object[] array;

        ArrayWrapper(Object[] objects) {
            this.array = objects;
        }
    }
}

