/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.validation.Validate;

class TypeResolvingContext {
    private Map<TypeVariable, Type> substitutions = new HashMap<TypeVariable, Type>();

    TypeResolvingContext() {
    }

    Type getSubstitution(Type type) {
        if (type instanceof TypeVariable) {
            Type resolved = this.substitutions.get(type);
            if (resolved instanceof TypeVariable) {
                return this.getSubstitution(resolved);
            }
            return resolved;
        }
        return null;
    }

    void addTypeSubstitutions(Class clazz) {
        Validate.argumentIsNotNull(clazz);
        if (clazz == Object.class) {
            return;
        }
        Type t = clazz.getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType genericSuperclass = (ParameterizedType)t;
        Class superclass = clazz.getSuperclass();
        TypeVariable<Class<T>>[] typeParameters = superclass.getTypeParameters();
        Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
        if (typeParameters.length == 0 || actualTypeArguments.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable typeParam = typeParameters[i];
            Type typeArg = actualTypeArguments[i];
            this.substitutions.put(typeParam, typeArg);
        }
    }
}

